/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.network;

import com.github.almostreliable.energymeter.meter.MeterContainer;
import com.github.almostreliable.energymeter.meter.MeterTile;
import com.github.almostreliable.energymeter.util.TypeEnums;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class AccuracyUpdatePacket {
    private TypeEnums.TEXT_BOX identifier;
    private int value;

    public AccuracyUpdatePacket(TypeEnums.TEXT_BOX identifier, int value) {
        this.identifier = identifier;
        this.value = value;
    }

    private AccuracyUpdatePacket() {
    }

    static AccuracyUpdatePacket decode(PacketBuffer buffer) {
        AccuracyUpdatePacket packet = new AccuracyUpdatePacket();
        packet.identifier = TypeEnums.TEXT_BOX.values()[buffer.readInt()];
        packet.value = buffer.readInt();
        return packet;
    }

    static void handle(AccuracyUpdatePacket packet, Supplier<? extends NetworkEvent.Context> context) {
        ServerPlayerEntity player = context.get().getSender();
        context.get().enqueueWork(() -> AccuracyUpdatePacket.handlePacket(packet, player));
        context.get().setPacketHandled(true);
    }

    private static void handlePacket(AccuracyUpdatePacket packet, @Nullable ServerPlayerEntity player) {
        if (player != null && player.field_71070_bA instanceof MeterContainer) {
            MeterTile tile = ((MeterContainer)player.field_71070_bA).getTile();
            World level = tile.func_145831_w();
            if (level == null || !level.func_195588_v(tile.func_174877_v())) {
                return;
            }
            if (packet.identifier == TypeEnums.TEXT_BOX.INTERVAL) {
                tile.setInterval(packet.value);
                tile.syncData(64);
            } else if (packet.identifier == TypeEnums.TEXT_BOX.THRESHOLD) {
                tile.setThreshold(packet.value);
                tile.syncData(128);
            }
            tile.func_70296_d();
        }
    }

    void encode(PacketBuffer buffer) {
        buffer.writeInt(this.identifier.ordinal());
        buffer.writeInt(this.value);
    }
}

