/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.meter;

import com.github.almostreliable.energymeter.compat.CapabilityAdapterFactory;
import com.github.almostreliable.energymeter.compat.ICapabilityAdapter;
import com.github.almostreliable.energymeter.compat.IMeterTileObserver;
import com.github.almostreliable.energymeter.compat.cct.MeterPeripheral;
import com.github.almostreliable.energymeter.component.SideConfiguration;
import com.github.almostreliable.energymeter.component.SidedEnergyStorage;
import com.github.almostreliable.energymeter.core.Setup;
import com.github.almostreliable.energymeter.meter.MeterBlock;
import com.github.almostreliable.energymeter.meter.MeterContainer;
import com.github.almostreliable.energymeter.network.ClientSyncPacket;
import com.github.almostreliable.energymeter.network.PacketHandler;
import com.github.almostreliable.energymeter.util.TextUtils;
import com.github.almostreliable.energymeter.util.TypeEnums;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.network.PacketDistributor;

public class MeterTile
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int REFRESH_RATE = 5;
    private final EnumMap<Direction, LazyOptional<IEnergyStorage>> outputCache = new EnumMap(Direction.class);
    private final List<LazyOptional<SidedEnergyStorage>> energyStorage;
    private final SideConfiguration sideConfig;
    private final List<Double> energyRates = Collections.synchronizedList(new ArrayList());
    private final Set<IMeterTileObserver> observers = Collections.synchronizedSet(new HashSet());
    @Nullable
    private final ICapabilityAdapter<MeterPeripheral> meterPeripheral;
    private boolean hasValidInput;
    private boolean setupDone;
    private LazyOptional<IEnergyStorage> inputCache;
    private double transferRate;
    private double averageRate;
    private TypeEnums.NUMBER_MODE numberMode = TypeEnums.NUMBER_MODE.SHORT;
    private TypeEnums.STATUS status = TypeEnums.STATUS.DISCONNECTED;
    private TypeEnums.MODE mode = TypeEnums.MODE.TRANSFER;
    private TypeEnums.ACCURACY accuracy = TypeEnums.ACCURACY.EXACT;
    private int interval = 5;
    private int threshold = 5;
    private double zeroThreshold;

    public MeterTile() {
        super((TileEntityType)Setup.Tiles.METER.get());
        this.energyStorage = SidedEnergyStorage.create(this);
        this.sideConfig = new SideConfiguration();
        this.meterPeripheral = CapabilityAdapterFactory.createMeterPeripheral(this);
    }

    public void updateSetting(TypeEnums.SETTING setting) {
        switch (setting) {
            case NUMBER: {
                this.numberMode = this.numberMode == TypeEnums.NUMBER_MODE.SHORT ? TypeEnums.NUMBER_MODE.LONG : TypeEnums.NUMBER_MODE.SHORT;
                this.syncData(4);
                break;
            }
            case MODE: {
                this.mode = this.mode == TypeEnums.MODE.TRANSFER ? TypeEnums.MODE.CONSUMER : TypeEnums.MODE.TRANSFER;
                this.syncData(16);
                break;
            }
            case ACCURACY: {
                int flags = 32;
                if (this.accuracy == TypeEnums.ACCURACY.EXACT) {
                    this.accuracy = TypeEnums.ACCURACY.INTERVAL;
                } else {
                    this.accuracy = TypeEnums.ACCURACY.EXACT;
                    this.interval = 5;
                    flags |= 0x40;
                }
                this.syncData(flags);
            }
        }
    }

    public void syncData(int flags) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        ClientSyncPacket packet = new ClientSyncPacket(this.field_174879_c, flags, this.sideConfig, this.transferRate, this.numberMode, this.status, this.mode, this.accuracy, this.interval, this.threshold);
        PacketHandler.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(this.field_174879_c)), (Object)packet);
        for (IMeterTileObserver observer : this.observers) {
            observer.onMeterTileChanged(this, flags);
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_74764_b("side_config")) {
            this.sideConfig.deserializeNBT(nbt.func_74775_l("side_config"));
        }
        if (nbt.func_74764_b("number_mode")) {
            this.numberMode = TypeEnums.NUMBER_MODE.values()[nbt.func_74762_e("number_mode")];
        }
        if (nbt.func_74764_b("mode")) {
            this.mode = TypeEnums.MODE.values()[nbt.func_74762_e("mode")];
        }
        if (nbt.func_74764_b("accuracy")) {
            this.accuracy = TypeEnums.ACCURACY.values()[nbt.func_74762_e("accuracy")];
        }
        if (nbt.func_74764_b("interval")) {
            this.interval = nbt.func_74762_e("interval");
        }
        if (nbt.func_74764_b("threshold")) {
            this.threshold = nbt.func_74762_e("threshold");
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_218657_a("side_config", (INBT)this.sideConfig.serializeNBT());
        nbt.func_74768_a("number_mode", this.numberMode.ordinal());
        nbt.func_74768_a("mode", this.mode.ordinal());
        nbt.func_74768_a("accuracy", this.accuracy.ordinal());
        nbt.func_74768_a("interval", this.interval);
        nbt.func_74768_a("threshold", this.threshold);
        return super.func_189515_b(nbt);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_218657_a("side_config", (INBT)this.sideConfig.serializeNBT());
        nbt.func_74780_a("transfer_rate", this.transferRate);
        nbt.func_74768_a("status", this.status.ordinal());
        nbt.func_74768_a("number_mode", this.numberMode.ordinal());
        nbt.func_74768_a("mode", this.mode.ordinal());
        nbt.func_74768_a("accuracy", this.accuracy.ordinal());
        nbt.func_74768_a("interval", this.interval);
        nbt.func_74768_a("threshold", this.threshold);
        return nbt;
    }

    public void func_145843_s() {
        for (IMeterTileObserver observer : this.observers) {
            observer.onMeterTileRemoved(this);
        }
        super.func_145843_s();
    }

    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        this.sideConfig.deserializeNBT(nbt.func_74775_l("side_config"));
        this.transferRate = nbt.func_74769_h("transfer_rate");
        this.status = TypeEnums.STATUS.values()[nbt.func_74762_e("status")];
        this.numberMode = TypeEnums.NUMBER_MODE.values()[nbt.func_74762_e("number_mode")];
        this.mode = TypeEnums.MODE.values()[nbt.func_74762_e("mode")];
        this.accuracy = TypeEnums.ACCURACY.values()[nbt.func_74762_e("accuracy")];
        this.interval = nbt.func_74762_e("interval");
        this.threshold = nbt.func_74762_e("threshold");
    }

    public int receiveEnergy(int energy, boolean simulate) {
        int acceptedEnergy;
        if (this.field_145850_b == null || !this.setupDone) {
            return 0;
        }
        if (this.mode == TypeEnums.MODE.CONSUMER) {
            if (!simulate) {
                this.averageRate += (double)energy;
            }
            return energy;
        }
        Map<IEnergyStorage, Integer> outputs = this.getPossibleOutputs(energy);
        if (outputs.isEmpty()) {
            return 0;
        }
        int maximumAccepted = outputs.values().stream().mapToInt(maxEnergy -> maxEnergy).sum();
        if (simulate) {
            return Math.min(maximumAccepted, energy);
        }
        if (maximumAccepted <= energy) {
            outputs.forEach((cap, integer) -> cap.receiveEnergy(integer.intValue(), false));
            acceptedEnergy = maximumAccepted;
        } else {
            acceptedEnergy = this.transferEnergy(energy, outputs);
        }
        this.averageRate += (double)acceptedEnergy;
        return acceptedEnergy;
    }

    public void updateNeighbors() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.field_145850_b.func_180501_a(this.field_174879_c, this.flipBlockState(), 9);
    }

    @Nullable
    public Container createMenu(int windowID, PlayerInventory inventory, PlayerEntity player) {
        return new MeterContainer(this, windowID);
    }

    public void subscribe(IMeterTileObserver observer) {
        this.observers.add(observer);
    }

    public void unsubscribe(IMeterTileObserver observer) {
        this.observers.remove(observer);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if ((this.thresholdReached() || this.intervalReached()) && !this.energyRates.isEmpty()) {
            this.calculateTransferRate();
        }
        if (this.field_145850_b.func_82737_E() % 5L != 0L) {
            return;
        }
        if (!this.setupDone) {
            for (Direction direction : Direction.values()) {
                if (this.sideConfig.get(direction) == TypeEnums.IO_SETTING.OFF) continue;
                this.updateCache(direction);
            }
            this.setupDone = true;
        }
        if (this.mode == TypeEnums.MODE.CONSUMER && !this.hasValidInput || this.mode == TypeEnums.MODE.TRANSFER && (!this.hasValidInput || !this.sideConfig.hasOutput() || !this.hasValidOutput())) {
            this.updateStatus(TypeEnums.STATUS.DISCONNECTED);
            return;
        }
        this.energyRates.add(this.averageRate);
        this.averageRate = 0.0;
        this.calculateThreshold();
        if (this.transferRate > 0.0) {
            this.updateStatus(TypeEnums.STATUS.TRANSFERRING);
        } else {
            this.updateStatus(TypeEnums.STATUS.CONNECTED);
        }
    }

    public void updateCache(Direction direction) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        TypeEnums.IO_SETTING setting = this.sideConfig.get(direction);
        if (setting == TypeEnums.IO_SETTING.IN) {
            this.hasValidInput = this.getInputFromCache(direction);
        } else if (setting == TypeEnums.IO_SETTING.OUT) {
            this.getOutputFromCache(direction);
        }
        if (!this.sideConfig.hasInput()) {
            this.hasValidInput = false;
            this.inputCache = null;
        }
    }

    protected void invalidateCaps() {
        for (LazyOptional<SidedEnergyStorage> cap : this.energyStorage) {
            cap.invalidate();
        }
        if (this.meterPeripheral != null) {
            this.meterPeripheral.getLazyAdapter().invalidate();
        }
        super.invalidateCaps();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction direction) {
        if (!this.field_145846_f) {
            if (cap.equals((Object)CapabilityEnergy.ENERGY) && direction != null && this.sideConfig.get(direction) != TypeEnums.IO_SETTING.OFF) {
                return this.energyStorage.get(direction.ordinal()).cast();
            }
            if (this.meterPeripheral != null && this.meterPeripheral.isCapability(cap)) {
                return this.meterPeripheral.getLazyAdapter().cast();
            }
        }
        return super.getCapability(cap, direction);
    }

    private int transferEnergy(int energy, Map<IEnergyStorage, Integer> outputs) {
        int acceptedEnergy = 0;
        int energyToTransfer = energy;
        while (!outputs.isEmpty() && energyToTransfer >= outputs.size()) {
            int equalSplit = energyToTransfer / outputs.size();
            ArrayList<IEnergyStorage> outputsToRemove = new ArrayList<IEnergyStorage>();
            for (Map.Entry<IEnergyStorage, Integer> output : outputs.entrySet()) {
                int actualSplit = equalSplit;
                if (output.getValue() < equalSplit) {
                    actualSplit = output.getValue();
                    outputsToRemove.add(output.getKey());
                }
                output.getKey().receiveEnergy(actualSplit, false);
                energyToTransfer -= actualSplit;
                acceptedEnergy += actualSplit;
            }
            outputsToRemove.forEach(outputs::remove);
        }
        return acceptedEnergy;
    }

    private Map<IEnergyStorage, Integer> getPossibleOutputs(int energy) {
        HashMap<IEnergyStorage, Integer> outputs = new HashMap<IEnergyStorage, Integer>();
        for (Direction direction : Direction.values()) {
            LazyOptional<IEnergyStorage> target;
            if (this.sideConfig.get(direction) != TypeEnums.IO_SETTING.OUT || (target = this.getOutputFromCache(direction)) == null) continue;
            target.ifPresent(cap -> {
                int accepted = cap.receiveEnergy(energy, true);
                if (accepted > 0) {
                    outputs.put((IEnergyStorage)cap, accepted);
                }
            });
        }
        return outputs;
    }

    @Nullable
    private LazyOptional<IEnergyStorage> getOutputFromCache(Direction direction) {
        assert (this.field_145850_b != null && !this.field_145850_b.field_72995_K);
        LazyOptional target = this.outputCache.get(direction);
        if (target == null) {
            TileEntity provider = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
            if (provider == null || provider instanceof MeterTile) {
                return null;
            }
            target = provider.getCapability(CapabilityEnergy.ENERGY, direction.func_176734_d());
            this.outputCache.put(direction, (LazyOptional<IEnergyStorage>)target);
            target.addListener(self -> {
                LazyOptional cfr_ignored_0 = this.outputCache.put(direction, null);
            });
        }
        return target;
    }

    private BlockState flipBlockState() {
        BlockState state;
        return (BlockState)state.func_206870_a((Property)MeterBlock.IO, (Comparable)Boolean.valueOf((Boolean)(state = this.func_195044_w()).func_177229_b((Property)MeterBlock.IO) == false));
    }

    private boolean thresholdReached() {
        return this.energyRates.size() * 5 >= this.threshold && this.zeroThreshold == 0.0;
    }

    private boolean intervalReached() {
        assert (this.field_145850_b != null);
        return this.field_145850_b.func_82737_E() % (long)this.interval == 0L;
    }

    private void calculateTransferRate() {
        assert (this.field_145850_b != null && !this.field_145850_b.field_72995_K);
        double oldTransferRate = this.transferRate;
        double average = this.energyRates.stream().mapToDouble(Double::valueOf).average().orElse(0.0);
        this.transferRate = average / 5.0;
        if (oldTransferRate != this.transferRate) {
            this.syncData(2);
        }
        this.energyRates.clear();
        if (this.accuracy == TypeEnums.ACCURACY.INTERVAL) {
            this.energyRates.add(average);
        }
    }

    private boolean hasValidOutput() {
        return this.outputCache.values().stream().anyMatch(Objects::nonNull);
    }

    private void updateStatus(TypeEnums.STATUS newStatus) {
        TypeEnums.STATUS oldStatus = this.status;
        this.status = newStatus;
        this.averageRate = 0.0;
        if (oldStatus != newStatus) {
            int flags = 8;
            if (newStatus != TypeEnums.STATUS.TRANSFERRING) {
                this.energyRates.clear();
                this.transferRate = 0.0;
                flags |= 2;
            }
            this.syncData(flags);
        }
    }

    private void calculateThreshold() {
        long skips = Math.max(0, this.energyRates.size() * 5 - this.threshold);
        this.zeroThreshold = this.energyRates.stream().skip(skips).reduce(0.0, Double::sum);
    }

    private boolean getInputFromCache(Direction direction) {
        assert (this.field_145850_b != null && !this.field_145850_b.field_72995_K);
        LazyOptional target = this.inputCache;
        if (target == null) {
            TileEntity provider = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
            if (provider instanceof MeterTile) {
                return false;
            }
            if (provider == null) {
                Block block = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(direction)).func_177230_c();
                return !block.func_235332_a_(Blocks.field_150350_a) && block.getRegistryName() != null && block.getRegistryName().func_110624_b().equals("pipez");
            }
            this.inputCache = target = provider.getCapability(CapabilityEnergy.ENERGY, direction.func_176734_d());
            target.addListener(self -> {
                this.inputCache = null;
            });
        }
        return true;
    }

    public SideConfiguration getSideConfig() {
        return this.sideConfig;
    }

    public TypeEnums.MODE getMode() {
        return this.mode;
    }

    public void setMode(TypeEnums.MODE mode) {
        this.mode = mode;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public double getTransferRate() {
        return (double)Math.round(this.transferRate * 1000.0) / 1000.0;
    }

    public void setTransferRate(double transferRate) {
        this.transferRate = transferRate;
    }

    public TypeEnums.STATUS getStatus() {
        if (this.status == TypeEnums.STATUS.TRANSFERRING) {
            return this.mode == TypeEnums.MODE.CONSUMER ? TypeEnums.STATUS.CONSUMING : TypeEnums.STATUS.TRANSFERRING;
        }
        return this.status;
    }

    public void setStatus(TypeEnums.STATUS status) {
        this.status = status;
    }

    public TypeEnums.NUMBER_MODE getNumberMode() {
        return this.numberMode;
    }

    public void setNumberMode(TypeEnums.NUMBER_MODE numberMode) {
        this.numberMode = numberMode;
    }

    public TypeEnums.ACCURACY getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(TypeEnums.ACCURACY accuracy) {
        this.accuracy = accuracy;
    }

    public ITextComponent func_145748_c_() {
        return TextUtils.translate(TypeEnums.TRANSLATE_TYPE.CONTAINER, "meter", new TextFormatting[0]);
    }
}

