/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.meter;

import com.github.almostreliable.energymeter.meter.MeterTile;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public class MeterBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final DirectionProperty BOTTOM = DirectionProperty.func_177712_a((String)"bottom", (Predicate)Direction.Plane.HORIZONTAL);
    static final BooleanProperty IO = BooleanProperty.func_177716_a((String)"io");
    private static final float STRENGTH = 3.0f;

    public MeterBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(3.0f).harvestTool(ToolType.PICKAXE).func_200947_a(SoundType.field_185852_e));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_196010_d().func_176734_d();
        Direction bottom = context.func_195992_f();
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)facing)).func_206870_a((Property)BOTTOM, (Comparable)(facing == Direction.DOWN ? bottom : bottom.func_176734_d()))).func_206870_a((Property)IO, (Comparable)Boolean.valueOf(false));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
        builder.func_206894_a(new Property[]{BOTTOM});
        builder.func_206894_a(new Property[]{IO});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader level) {
        return new MeterTile();
    }

    public void func_220069_a(BlockState state, World level, BlockPos pos, Block block, BlockPos neighbor, boolean isMoving) {
        super.func_220069_a(state, level, pos, block, neighbor, isMoving);
        if (!state.hasTileEntity()) {
            return;
        }
        TileEntity tile = level.func_175625_s(pos);
        if (!(tile instanceof MeterTile)) {
            return;
        }
        BlockState neighborState = level.func_180495_p(neighbor);
        ResourceLocation registryName = neighborState.func_177230_c().getRegistryName();
        if (!(neighborState.func_203425_a(Blocks.field_150350_a) || neighborState.hasTileEntity() || registryName == null || registryName.func_110624_b().equals("pipez"))) {
            return;
        }
        BlockPos vector = neighbor.func_177973_b((Vector3i)pos);
        Direction direction = Direction.func_218383_a((int)vector.func_177958_n(), (int)vector.func_177956_o(), (int)vector.func_177952_p());
        if (direction == null) {
            return;
        }
        ((MeterTile)tile).updateCache(direction);
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (level.func_201670_d() || player.func_225608_bj_()) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tile = level.func_175625_s(pos);
        if (tile instanceof INamedContainerProvider && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tile), (BlockPos)pos);
        }
        return ActionResultType.CONSUME;
    }
}

