/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.core;

import com.github.almostreliable.energymeter.meter.MeterBlock;
import com.github.almostreliable.energymeter.meter.MeterContainer;
import com.github.almostreliable.energymeter.meter.MeterTile;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class Setup {
    private static final Tab TAB = new Tab("energymeter");

    private Setup() {
    }

    public static void init(IEventBus modEventBus) {
        Blocks.REGISTRY.register(modEventBus);
        Blocks.ITEMS.register(modEventBus);
        Tiles.REGISTRY.register(modEventBus);
        Containers.REGISTRY.register(modEventBus);
    }

    private static class Blocks {
        private static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"energymeter");
        private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"energymeter");
        private static final RegistryObject<MeterBlock> METER_BLOCK = Blocks.register("meter", MeterBlock::new);

        private Blocks() {
        }

        private static <B extends MeterBlock> RegistryObject<B> register(String id, Supplier<? extends B> supplier) {
            RegistryObject result = REGISTRY.register(id, supplier);
            ITEMS.register(id, () -> new BlockItem((Block)result.get(), new Item.Properties().func_200916_a((ItemGroup)TAB)));
            return result;
        }
    }

    private static final class Tab
    extends ItemGroup {
        private Tab(String label) {
            super(label);
        }

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)Blocks.METER_BLOCK.get());
        }
    }

    public static final class Containers {
        private static final DeferredRegister<ContainerType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"energymeter");
        public static final RegistryObject<ContainerType<MeterContainer>> METER_CONTAINER = Containers.register("meter", MeterContainer::new);

        private Containers() {
        }

        private static <C extends MeterContainer> RegistryObject<ContainerType<C>> register(String id, BiFunction<? super MeterTile, ? super Integer, ? extends C> constructor) {
            return REGISTRY.register(id, () -> IForgeContainerType.create((containerID, inventory, data) -> {
                MeterTile tile = (MeterTile)inventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
                return (MeterContainer)((Object)((Object)((Object)constructor.apply(tile, containerID))));
            }));
        }
    }

    public static final class Tiles {
        private static final DeferredRegister<TileEntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"energymeter");
        public static final RegistryObject<TileEntityType<MeterTile>> METER = Tiles.register("meter", Blocks.access$500(), MeterTile::new);

        private Tiles() {
        }

        private static <T extends MeterTile, B extends MeterBlock> RegistryObject<TileEntityType<T>> register(String id, RegistryObject<B> block, Supplier<T> constructor) {
            return REGISTRY.register(id, () -> TileEntityType.Builder.func_223042_a((Supplier)constructor, (Block[])new Block[]{(Block)block.get()}).func_206865_a(null));
        }
    }
}

