/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.component;

import com.github.almostreliable.energymeter.meter.MeterBlock;
import com.github.almostreliable.energymeter.util.TypeEnums;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.INBTSerializable;

public class SideConfiguration
implements INBTSerializable<CompoundNBT> {
    private static final int MAX_OUTPUTS = 4;
    private final EnumMap<Direction, TypeEnums.IO_SETTING> config = new EnumMap(Direction.class);

    public SideConfiguration() {
        for (Direction direction : Direction.values()) {
            this.config.put(direction, TypeEnums.IO_SETTING.OFF);
        }
    }

    public static Direction getDirectionFromSide(BlockState state, TypeEnums.BLOCK_SIDE side) {
        Direction bottom;
        Direction facing = (Direction)state.func_177229_b((Property)MeterBlock.FACING);
        return facing == (bottom = (Direction)state.func_177229_b((Property)MeterBlock.BOTTOM)) ? SideConfiguration.horizontalConversion(facing, side) : SideConfiguration.verticalConversion(facing, bottom, side);
    }

    private static Direction horizontalConversion(Direction facing, TypeEnums.BLOCK_SIDE side) {
        switch (side) {
            case TOP: {
                return Direction.UP;
            }
            case BOTTOM: {
                return Direction.DOWN;
            }
            case LEFT: {
                return facing.func_176746_e();
            }
            case RIGHT: {
                return facing.func_176735_f();
            }
            case BACK: {
                return facing.func_176734_d();
            }
        }
        return facing;
    }

    private static Direction verticalConversion(Direction facing, Direction bottom, TypeEnums.BLOCK_SIDE side) {
        switch (side) {
            case TOP: {
                return bottom.func_176734_d();
            }
            case BOTTOM: {
                return bottom;
            }
            case LEFT: {
                return facing == Direction.UP ? bottom.func_176746_e() : bottom.func_176735_f();
            }
            case RIGHT: {
                return facing == Direction.UP ? bottom.func_176735_f() : bottom.func_176746_e();
            }
            case BACK: {
                return facing.func_176734_d();
            }
        }
        return facing;
    }

    public TypeEnums.IO_SETTING get(Direction direction) {
        return this.config.get(direction);
    }

    public TypeEnums.IO_SETTING get(BlockState state, TypeEnums.BLOCK_SIDE side) {
        return this.config.get(SideConfiguration.getDirectionFromSide(state, side));
    }

    public void set(BlockState state, TypeEnums.BLOCK_SIDE side, TypeEnums.IO_SETTING setting) {
        this.config.put(SideConfiguration.getDirectionFromSide(state, side), setting);
    }

    public boolean hasInput() {
        return this.config.containsValue((Object)TypeEnums.IO_SETTING.IN);
    }

    public boolean hasOutput() {
        return this.config.containsValue((Object)TypeEnums.IO_SETTING.OUT);
    }

    public boolean hasMaxOutputs() {
        return this.config.values().stream().filter(setting -> setting == TypeEnums.IO_SETTING.OUT).count() == 4L;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        for (Direction direction : Direction.values()) {
            nbt.func_74768_a(direction.toString(), this.config.get(direction).ordinal());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        for (Direction direction : Direction.values()) {
            this.config.put(direction, TypeEnums.IO_SETTING.values()[nbt.func_74762_e(direction.toString())]);
        }
    }

    public Map<String, String> asStringMap() {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry<Direction, TypeEnums.IO_SETTING> entry : this.config.entrySet()) {
            stringMap.put(entry.getKey().func_176742_j(), entry.getValue().name());
        }
        return stringMap;
    }
}

