/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.client.gui;

import com.github.almostreliable.energymeter.client.gui.IOButton;
import com.github.almostreliable.energymeter.client.gui.IntervalBox;
import com.github.almostreliable.energymeter.client.gui.SettingButton;
import com.github.almostreliable.energymeter.client.gui.ThresholdBox;
import com.github.almostreliable.energymeter.meter.MeterContainer;
import com.github.almostreliable.energymeter.util.GuiUtils;
import com.github.almostreliable.energymeter.util.TextUtils;
import com.github.almostreliable.energymeter.util.TypeEnums;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class MeterScreen
extends ContainerScreen<MeterContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("energymeter", "textures/gui/meter.png");
    private static final int TEXTURE_WIDTH = 199;
    private static final int TEXTURE_HEIGHT = 129;
    private static final GuiUtils.Tooltip TOOLTIP = MeterScreen.setupTooltip();
    private final Collection<Widget> renderables = new ArrayList<Widget>();
    private IntervalBox intervalBox;
    private ThresholdBox thresholdBox;

    public MeterScreen(MeterContainer container, PlayerInventory inventory, ITextComponent name) {
        super((Container)container, inventory, name);
        this.field_146999_f = 199;
        this.field_147000_g = 129;
    }

    private static GuiUtils.Tooltip setupTooltip() {
        return GuiUtils.Tooltip.builder().addHeader("side_config").addBlankLine().addComponent((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "io_side", TextFormatting.GREEN).func_230529_a_((ITextComponent)TextUtils.colorize(": ", TextFormatting.GREEN)).func_230529_a_((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.BLOCK_SIDE, TypeEnums.BLOCK_SIDE.FRONT.toString().toLowerCase(), TextFormatting.WHITE))).addComponent((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "io_mode", TextFormatting.GREEN).func_230529_a_((ITextComponent)TextUtils.colorize(": ", TextFormatting.GREEN)).func_230529_a_((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.IO_SETTING, "screen", TextFormatting.WHITE)));
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.intervalBox = new IntervalBox(this, this.field_230712_o_, this.field_147003_i + 18, this.field_147009_r + this.field_147000_g + 5, 42, 8);
        this.addRenderable((Widget)this.intervalBox);
        this.thresholdBox = new ThresholdBox(this, this.field_230712_o_, this.field_147003_i + 81, this.field_147009_r + this.field_147000_g + 5, 42, 8);
        this.addRenderable((Widget)this.thresholdBox);
        this.addRenderables(IOButton.create(this, TypeEnums.BLOCK_SIDE.values()));
        this.addRenderable((Widget)new SettingButton(this, 136, 64, TypeEnums.SETTING.NUMBER));
        this.addRenderable((Widget)new SettingButton(this, 136, 86, TypeEnums.SETTING.MODE));
        this.addRenderable((Widget)new SettingButton(this, 136, 108, TypeEnums.SETTING.ACCURACY));
    }

    public void func_230430_a_(MatrixStack matrix, int mX, int mY, float partial) {
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mX, mY, partial);
        this.func_230459_a_(matrix, mX, mY);
    }

    protected void func_230459_a_(MatrixStack matrix, int mX, int mY) {
        if (this.isWithinRegion(mX, mY, 159, 16, 23, 16)) {
            this.func_243308_b(matrix, TOOLTIP.resolve(), mX, mY);
            return;
        }
        for (Widget widget : this.renderables) {
            if (!widget.func_230449_g_() || !widget.field_230694_p_) continue;
            widget.func_230443_a_(matrix, mX, mY);
        }
        super.func_230459_a_(matrix, mX, mY);
    }

    protected void func_230451_b_(MatrixStack matrix, int pX, int pY) {
        GuiUtils.renderText(matrix, 11, 9, 1.3f, TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.LABEL, "meter"), 0xF0F0F0);
        GuiUtils.renderText(matrix, 11, 26, 1.1f, TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.LABEL, "transfer_rate") + ':', 0xAEAEAE);
        Tuple<String, String> formattedFlow = TextUtils.formatEnergy(((MeterContainer)this.field_147002_h).getTile().getTransferRate(), ((MeterContainer)this.field_147002_h).getTile().getNumberMode() == TypeEnums.NUMBER_MODE.LONG);
        GuiUtils.renderText(matrix, 16, 37, 1.0f, String.format("%s %s/t", formattedFlow.func_76341_a(), formattedFlow.func_76340_b()), 65442);
        GuiUtils.renderText(matrix, 11, 50, 1.1f, TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.LABEL, "status") + ':', 0xAEAEAE);
        GuiUtils.renderText(matrix, 16, 61, 1.0f, TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.STATUS, ((MeterContainer)this.field_147002_h).getTile().getStatus().toString().toLowerCase()), this.getStatusColor());
        GuiUtils.renderText(matrix, 11, 74, 1.1f, TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.LABEL, "mode") + ':', 0xAEAEAE);
        GuiUtils.renderText(matrix, 16, 85, 1.0f, TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.MODE, ((MeterContainer)this.field_147002_h).getTile().getMode().toString().toLowerCase()), this.getModeColor());
        GuiUtils.renderText(matrix, 11, 98, 1.1f, TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.LABEL, "accuracy") + ':', 0xAEAEAE);
        GuiUtils.renderText(matrix, 16, 109, 1.0f, TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.ACCURACY, ((MeterContainer)this.field_147002_h).getTile().getAccuracy().toString().toLowerCase()), this.getAccuracyColor());
    }

    protected void func_230450_a_(MatrixStack matrix, float partial, int pX, int pY) {
        if (this.field_230706_i_ == null) {
            return;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        MeterScreen.func_238463_a_((MatrixStack)matrix, (int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)this.field_146999_f, (int)this.field_147000_g);
    }

    private void addRenderable(Widget widget) {
        this.func_230480_a_(widget);
        this.renderables.add(widget);
    }

    private <T extends Widget> void addRenderables(Iterable<T> widgets) {
        for (Widget widget : widgets) {
            this.addRenderable(widget);
        }
    }

    private boolean isWithinRegion(int mX, int mY, int pX, int width, int pY, int height) {
        return mX >= this.field_147003_i + pX && mX <= this.field_147003_i + pX + width && mY >= this.field_147009_r + pY && mY <= this.field_147009_r + pY + height;
    }

    IntervalBox getIntervalBox() {
        return this.intervalBox;
    }

    ThresholdBox getThresholdBox() {
        return this.thresholdBox;
    }

    private int getStatusColor() {
        TypeEnums.STATUS connection = ((MeterContainer)this.field_147002_h).getTile().getStatus();
        switch (connection) {
            case DISCONNECTED: {
                return 14286889;
            }
            case CONNECTED: {
                return 16768512;
            }
            case TRANSFERRING: {
                return 65328;
            }
            case CONSUMING: {
                return 0xFF00F0;
            }
        }
        throw new IllegalStateException("There is no connection status with value: " + (Object)((Object)connection));
    }

    private int getModeColor() {
        return ((MeterContainer)this.field_147002_h).getTile().getMode() == TypeEnums.MODE.CONSUMER ? 12976383 : 40929;
    }

    private int getAccuracyColor() {
        return ((MeterContainer)this.field_147002_h).getTile().getAccuracy() == TypeEnums.ACCURACY.EXACT ? 0xFF6600 : 0xFF0066;
    }
}

