/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.client.gui;

import com.github.almostreliable.energymeter.client.gui.GenericButton;
import com.github.almostreliable.energymeter.client.gui.MeterScreen;
import com.github.almostreliable.energymeter.component.SideConfiguration;
import com.github.almostreliable.energymeter.meter.MeterContainer;
import com.github.almostreliable.energymeter.network.IOUpdatePacket;
import com.github.almostreliable.energymeter.network.PacketHandler;
import com.github.almostreliable.energymeter.util.GuiUtils;
import com.github.almostreliable.energymeter.util.TextUtils;
import com.github.almostreliable.energymeter.util.TypeEnums;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

final class IOButton
extends GenericButton {
    private static final String TEXTURE = "io";
    private static final int POS_X = 141;
    private static final int POS_Y = 5;
    private static final int TEXTURE_WIDTH = 34;
    private static final int TEXTURE_HEIGHT = 34;
    private static final int BUTTON_SIZE = 17;
    private static final int ZONE_SIZE = 18;
    private static final int OVERLAY_SIZE = 17;
    private final TypeEnums.BLOCK_SIDE side;
    private GuiUtils.Tooltip tooltip;
    private TypeEnums.IO_SETTING setting;

    private IOButton(MeterScreen screen, TypeEnums.BLOCK_SIDE side) {
        super(screen, 141 + (Integer)IOButton.getButtonPos(side).func_76341_a(), 5 + (Integer)IOButton.getButtonPos(side).func_76340_b(), 17, 17);
        this.side = side;
        this.setting = this.container.getTile().getSideConfig().get(((MeterContainer)screen.func_212873_a_()).getTile().func_195044_w(), side);
        this.tooltip = this.setupTooltip();
    }

    static List<IOButton> create(MeterScreen screen, TypeEnums.BLOCK_SIDE ... sides) {
        return Arrays.stream(sides).filter(side -> side != TypeEnums.BLOCK_SIDE.FRONT).map(side -> new IOButton(screen, (TypeEnums.BLOCK_SIDE)((Object)side))).collect(Collectors.toList());
    }

    private static Tuple<Integer, Integer> getButtonPos(TypeEnums.BLOCK_SIDE side) {
        switch (side) {
            case TOP: {
                return new Tuple((Object)18, (Object)0);
            }
            case LEFT: {
                return new Tuple((Object)0, (Object)18);
            }
            case RIGHT: {
                return new Tuple((Object)36, (Object)18);
            }
            case BOTTOM: {
                return new Tuple((Object)18, (Object)36);
            }
            case BACK: {
                return new Tuple((Object)36, (Object)36);
            }
        }
        return new Tuple((Object)0, (Object)0);
    }

    public void func_230443_a_(MatrixStack matrix, int mX, int mY) {
        this.screen.func_243308_b(matrix, this.tooltip.resolve(), mX, mY);
    }

    public void func_230982_a_(double mX, double mY) {
        if (this.field_230692_n_) {
            this.changeMode(Screen.func_231173_s_());
        }
        super.func_230982_a_(mX, mY);
    }

    @Override
    public void func_230431_b_(MatrixStack matrix, int mX, int mY, float partial) {
        super.func_230431_b_(matrix, mX, mY, partial);
        this.renderIOOverlay(matrix);
    }

    @Override
    protected void clickHandler() {
        PacketHandler.CHANNEL.sendToServer((Object)new IOUpdatePacket(this.side, this.setting));
        this.tooltip = this.setupTooltip();
    }

    @Override
    protected String getTexture() {
        return TEXTURE;
    }

    @Override
    protected int getTextureWidth() {
        return 34;
    }

    @Override
    protected int getTextureHeight() {
        return 34;
    }

    private GuiUtils.Tooltip setupTooltip() {
        return GuiUtils.Tooltip.builder().addHeader("side_config").addBlankLine().addComponent((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "io_side", TextFormatting.GREEN).func_230529_a_((ITextComponent)TextUtils.colorize(": ", TextFormatting.GREEN)).func_230529_a_((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.BLOCK_SIDE, this.side.toString().toLowerCase(), TextFormatting.WHITE))).addComponent((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "io_mode", TextFormatting.GREEN).func_230529_a_((ITextComponent)TextUtils.colorize(": ", TextFormatting.GREEN)).func_230529_a_((ITextComponent)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.IO_SETTING, this.setting.toString().toLowerCase(), TextFormatting.WHITE))).addBlankLine().addClickAction("action_1").addShiftClickAction("action_2");
    }

    private void renderIOOverlay(MatrixStack matrix) {
        int textureOffset = (this.setting.ordinal() - 1) * 17;
        if (textureOffset >= 0) {
            IOButton.func_238463_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)17.0f, (float)textureOffset, (int)17, (int)17, (int)34, (int)34);
        }
    }

    private void changeMode(boolean reset) {
        if (reset) {
            this.setting = TypeEnums.IO_SETTING.OFF;
            return;
        }
        SideConfiguration sideConfig = this.container.getTile().getSideConfig();
        switch (this.setting) {
            case OFF: {
                this.setting = sideConfig.hasInput() ? TypeEnums.IO_SETTING.OUT : TypeEnums.IO_SETTING.IN;
                break;
            }
            case IN: {
                this.setting = sideConfig.hasMaxOutputs() ? TypeEnums.IO_SETTING.OFF : TypeEnums.IO_SETTING.OUT;
                break;
            }
            case OUT: {
                this.setting = TypeEnums.IO_SETTING.OFF;
                break;
            }
            default: {
                throw new IllegalArgumentException("There is no IO mode called " + (Object)((Object)this.setting));
            }
        }
    }
}

