/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.client;

import com.github.almostreliable.energymeter.meter.MeterBlock;
import com.github.almostreliable.energymeter.meter.MeterTile;
import com.github.almostreliable.energymeter.util.TextUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.TextFormatting;

public class MeterRenderer
extends TileEntityRenderer<MeterTile> {
    private static final float[] ANGLE = new float[]{0.0f, 0.0f, 0.0f, 180.0f, 90.0f, -90.0f};
    private static final float PIXEL_SIZE = 0.01875f;
    private static final float OFFSET = 0.001f;
    private static final int MAX_DISTANCE = 30;
    private static final float HALF = 0.5f;
    private final Minecraft mc = Minecraft.func_71410_x();
    private final FontRenderer font;

    public MeterRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.font = this.mc.field_71466_p;
    }

    public void render(MeterTile tile, float partial, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay) {
        if (tile.func_174877_v().func_177951_i((Vector3i)this.mc.field_71439_g.func_233580_cy_()) > Math.pow(30.0, 2.0)) {
            return;
        }
        Direction facing = (Direction)tile.func_195044_w().func_177229_b((Property)MeterBlock.FACING);
        Direction bottom = (Direction)tile.func_195044_w().func_177229_b((Property)MeterBlock.BOTTOM);
        Vector3f vector = this.getFacingVector(facing);
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)vector.func_195899_a(), (double)vector.func_195900_b(), (double)vector.func_195902_c());
        if (facing == bottom) {
            matrix.func_227863_a_(new Quaternion(0.0f, ANGLE[facing.ordinal()], 180.0f, true));
        } else {
            matrix.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
            matrix.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(facing == Direction.UP ? 90.0f : -90.0f));
            matrix.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(facing == Direction.DOWN ? 180.0f - ANGLE[bottom.ordinal()] : ANGLE[bottom.ordinal()]));
        }
        matrix.func_227862_a_(0.01875f, 0.01875f, 0.0f);
        Tuple<String, String> text = TextUtils.formatEnergy(tile.getTransferRate(), false);
        String flowRate = (String)text.func_76341_a();
        String unit = (String)text.func_76340_b() + "/t";
        float f = (float)this.font.func_78256_a(flowRate) / -2.0f;
        this.font.getClass();
        this.font.func_238421_b_(matrix, flowRate, f, (float)(-9) - 0.001f, TextFormatting.WHITE.func_211163_e().intValue());
        this.font.func_238421_b_(matrix, unit, (float)this.font.func_78256_a(unit) / -2.0f, 0.001f, TextFormatting.WHITE.func_211163_e().intValue());
        matrix.func_227865_b_();
    }

    private Vector3f getFacingVector(Direction facing) {
        if (facing.ordinal() < 2) {
            return new Vector3f(0.5f, facing == Direction.UP ? 1.001f : -0.001f, 0.5f);
        }
        if (facing.ordinal() < 4) {
            return new Vector3f(0.5f, 0.5f, facing == Direction.NORTH ? -0.001f : 1.001f);
        }
        return new Vector3f(facing == Direction.WEST ? -0.001f : 1.001f, 0.5f, 0.5f);
    }
}

