/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.network.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSyncedEffect {
    private final BlockPos pos;
    private final Type type;

    public MessageSyncedEffect(BlockPos pos, Type type) {
        this.pos = pos;
        this.type = type;
    }

    public static void encode(MessageSyncedEffect message, PacketBuffer buf) {
        buf.writeLong(message.pos.func_218275_a());
        buf.writeByte(message.type.ordinal());
    }

    public static MessageSyncedEffect decode(PacketBuffer buf) {
        BlockPos pos = buf.func_179259_c();
        Type type = Type.values()[buf.readByte()];
        return new MessageSyncedEffect(pos, type);
    }

    public static void handle(MessageSyncedEffect message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            BasicParticleType particleType = ParticleTypes.field_197627_t;
            int particleCount = 1;
            float particleRandomOffset = 1.0f;
            Vector3i particleOffset = Vector3i.field_177959_e;
            SoundEvent soundEvent = null;
            float volume = 1.0f;
            switch (message.type) {
                case COW_IN_A_JAR: {
                    soundEvent = SoundEvents.field_187665_Y;
                    particleOffset = new Vector3i(0, 1, 0);
                    break;
                }
                case OVEN_UPGRADE: 
                case FRIDGE_UPGRADE: {
                    soundEvent = SoundEvents.field_187698_i;
                    particleType = ParticleTypes.field_197594_E;
                    particleCount = 10;
                    volume = 0.5f;
                }
            }
            if (soundEvent != null) {
                Minecraft.func_71410_x().field_71441_e.func_184134_a((double)message.pos.func_177958_n(), (double)message.pos.func_177956_o(), (double)message.pos.func_177952_p(), soundEvent, SoundCategory.BLOCKS, volume, 1.0f, false);
            }
            for (int i = 0; i < particleCount; ++i) {
                float offsetX = (float)particleOffset.func_177958_n() + 0.5f + (float)(Math.random() - 0.5) * particleRandomOffset;
                float offsetY = (float)particleOffset.func_177958_n() + 0.5f + (float)(Math.random() - 0.5) * particleRandomOffset;
                float offsetZ = (float)particleOffset.func_177958_n() + 0.5f + (float)(Math.random() - 0.5) * particleRandomOffset;
                Minecraft.func_71410_x().field_71441_e.func_195590_a((IParticleData)particleType, true, (double)((float)message.pos.func_177958_n() + offsetX), (double)((float)message.pos.func_177956_o() + offsetY), (double)((float)message.pos.func_177952_p() + offsetZ), 0.0, 0.0, 0.0);
            }
        });
        context.setPacketHandled(true);
    }

    public static enum Type {
        COW_IN_A_JAR,
        OVEN_UPGRADE,
        FRIDGE_UPGRADE;

    }
}

