/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.nio.protocol;

import dark.org.http.ContentTooLongException;
import dark.org.http.HttpEntity;
import dark.org.http.HttpResponse;
import dark.org.http.entity.ContentType;
import dark.org.http.nio.ContentDecoder;
import dark.org.http.nio.IOControl;
import dark.org.http.nio.entity.ContentBufferEntity;
import dark.org.http.nio.protocol.AbstractAsyncResponseConsumer;
import dark.org.http.nio.util.HeapByteBufferAllocator;
import dark.org.http.nio.util.SimpleInputBuffer;
import dark.org.http.protocol.HttpContext;
import dark.org.http.util.Asserts;
import java.io.IOException;

public class BasicAsyncResponseConsumer
extends AbstractAsyncResponseConsumer<HttpResponse> {
    private static final int MAX_INITIAL_BUFFER_SIZE = 262144;
    private volatile HttpResponse response;
    private volatile SimpleInputBuffer buf;

    @Override
    protected void onResponseReceived(HttpResponse response) throws IOException {
        this.response = response;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: %,d", len);
        }
        if (len < 0L) {
            len = 4096L;
        }
        int initialBufferSize = Math.min((int)len, 262144);
        this.buf = new SimpleInputBuffer(initialBufferSize, new HeapByteBufferAllocator());
        this.response.setEntity(new ContentBufferEntity(entity, this.buf));
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioControl) throws IOException {
        Asserts.notNull(this.buf, "Content buffer");
        this.buf.consumeContent(decoder);
    }

    @Override
    protected void releaseResources() {
        this.response = null;
        this.buf = null;
    }

    @Override
    protected HttpResponse buildResult(HttpContext context) {
        return this.response;
    }
}

