/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.nio.protocol;

import dark.org.http.HttpException;
import dark.org.http.HttpRequest;
import dark.org.http.annotation.Contract;
import dark.org.http.annotation.ThreadingBehavior;
import dark.org.http.nio.protocol.BasicAsyncRequestConsumer;
import dark.org.http.nio.protocol.HttpAsyncExchange;
import dark.org.http.nio.protocol.HttpAsyncRequestConsumer;
import dark.org.http.nio.protocol.HttpAsyncRequestHandler;
import dark.org.http.protocol.HttpContext;
import dark.org.http.protocol.HttpRequestHandler;
import dark.org.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class BasicAsyncRequestHandler
implements HttpAsyncRequestHandler<HttpRequest> {
    private final HttpRequestHandler handler;

    public BasicAsyncRequestHandler(HttpRequestHandler handler) {
        Args.notNull(handler, "Request handler");
        this.handler = handler;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest request, HttpContext context) {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(HttpRequest request, HttpAsyncExchange httpexchange, HttpContext context) throws HttpException, IOException {
        this.handler.handle(request, httpexchange.getResponse(), context);
        httpexchange.submitResponse();
    }
}

