/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.impl.nio.conn;

import dark.org.commons.logging.Log;
import dark.org.commons.logging.LogFactory;
import dark.org.http.Header;
import dark.org.http.HttpRequest;
import dark.org.http.HttpResponse;
import dark.org.http.HttpResponseFactory;
import dark.org.http.impl.nio.DefaultNHttpClientConnection;
import dark.org.http.impl.nio.conn.LoggingIOSession;
import dark.org.http.nio.conn.ClientAsyncConnection;
import dark.org.http.nio.reactor.IOSession;
import dark.org.http.nio.util.ByteBufferAllocator;
import dark.org.http.params.HttpParams;

@Deprecated
public class DefaultClientAsyncConnection
extends DefaultNHttpClientConnection
implements ClientAsyncConnection {
    private final Log headerlog = LogFactory.getLog("dark.org.http.headers");
    private final Log wirelog = LogFactory.getLog("dark.org.http.wire");
    private final Log log;
    private final String id;
    private IOSession original;

    public DefaultClientAsyncConnection(String id, IOSession iosession, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        super(iosession, responseFactory, allocator, params);
        this.id = id;
        this.original = iosession;
        this.log = LogFactory.getLog(iosession.getClass());
        if (this.log.isDebugEnabled() || this.wirelog.isDebugEnabled()) {
            this.bind(new LoggingIOSession(iosession, this.id, this.log, this.wirelog));
        }
    }

    @Override
    public void upgrade(IOSession iosession) {
        this.original = iosession;
        if (this.log.isDebugEnabled() || this.wirelog.isDebugEnabled()) {
            this.log.debug(this.id + " Upgrade session " + iosession);
            this.bind(new LoggingIOSession(iosession, this.id, this.headerlog, this.wirelog));
        } else {
            this.bind(iosession);
        }
    }

    @Override
    public IOSession getIOSession() {
        return this.original;
    }

    public String getId() {
        return this.id;
    }

    @Override
    protected void onResponseReceived(HttpResponse response) {
        if (response != null && this.headerlog.isDebugEnabled()) {
            Header[] headers;
            this.headerlog.debug(this.id + " << " + response.getStatusLine().toString());
            for (Header header : headers = response.getAllHeaders()) {
                this.headerlog.debug(this.id + " << " + header.toString());
            }
        }
    }

    @Override
    protected void onRequestSubmitted(HttpRequest request) {
        if (request != null && this.headerlog.isDebugEnabled()) {
            Header[] headers;
            this.headerlog.debug(this.id + " >> " + request.getRequestLine().toString());
            for (Header header : headers = request.getAllHeaders()) {
                this.headerlog.debug(this.id + " >> " + header.toString());
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.id);
        buf.append(" [");
        switch (this.status) {
            case 0: {
                buf.append("ACTIVE");
                if (!this.inbuf.hasData()) break;
                buf.append("(").append(this.inbuf.length()).append(")");
                break;
            }
            case 1: {
                buf.append("CLOSING");
                break;
            }
            case 2: {
                buf.append("CLOSED");
            }
        }
        buf.append("]");
        return buf.toString();
    }
}

