/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.impl.nio.codecs;

import dark.org.http.HttpResponse;
import dark.org.http.HttpResponseFactory;
import dark.org.http.annotation.Contract;
import dark.org.http.annotation.ThreadingBehavior;
import dark.org.http.config.MessageConstraints;
import dark.org.http.impl.DefaultHttpResponseFactory;
import dark.org.http.impl.nio.codecs.DefaultHttpResponseParser;
import dark.org.http.message.BasicLineParser;
import dark.org.http.message.LineParser;
import dark.org.http.nio.NHttpMessageParser;
import dark.org.http.nio.NHttpMessageParserFactory;
import dark.org.http.nio.reactor.SessionInputBuffer;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements NHttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public NHttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

