/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.impl.nio.client;

import dark.org.http.HttpHost;
import dark.org.http.HttpRequest;
import dark.org.http.HttpResponse;
import dark.org.http.annotation.Contract;
import dark.org.http.annotation.ThreadingBehavior;
import dark.org.http.client.protocol.HttpClientContext;
import dark.org.http.concurrent.FutureCallback;
import dark.org.http.impl.nio.client.CloseableHttpAsyncClient;
import dark.org.http.nio.client.HttpPipeliningClient;
import dark.org.http.nio.client.methods.HttpAsyncMethods;
import dark.org.http.nio.protocol.HttpAsyncRequestProducer;
import dark.org.http.nio.protocol.HttpAsyncResponseConsumer;
import dark.org.http.protocol.HttpContext;
import dark.org.http.util.Args;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class CloseableHttpPipeliningClient
extends CloseableHttpAsyncClient
implements HttpPipeliningClient {
    @Override
    public <T> Future<List<T>> execute(HttpHost target, List<? extends HttpAsyncRequestProducer> requestProducers, List<? extends HttpAsyncResponseConsumer<T>> responseConsumers, FutureCallback<List<T>> callback) {
        return this.execute(target, requestProducers, responseConsumers, HttpClientContext.create(), callback);
    }

    @Override
    public Future<List<HttpResponse>> execute(HttpHost target, List<HttpRequest> requests, FutureCallback<List<HttpResponse>> callback) {
        return this.execute(target, requests, (HttpContext)HttpClientContext.create(), callback);
    }

    @Override
    public Future<List<HttpResponse>> execute(HttpHost target, List<HttpRequest> requests, HttpContext context, FutureCallback<List<HttpResponse>> callback) {
        Args.notEmpty(requests, "HTTP request list");
        ArrayList<HttpAsyncRequestProducer> requestProducers = new ArrayList<HttpAsyncRequestProducer>(requests.size());
        ArrayList<HttpAsyncResponseConsumer<HttpResponse>> responseConsumers = new ArrayList<HttpAsyncResponseConsumer<HttpResponse>>(requests.size());
        for (int i = 0; i < requests.size(); ++i) {
            HttpRequest request = requests.get(i);
            requestProducers.add(HttpAsyncMethods.create(target, request));
            responseConsumers.add(HttpAsyncMethods.createConsumer());
        }
        return this.execute(target, requestProducers, responseConsumers, context, callback);
    }
}

