/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.impl.nio;

import dark.org.http.HttpResponseFactory;
import dark.org.http.impl.DefaultHttpResponseFactory;
import dark.org.http.impl.nio.DefaultNHttpClientConnection;
import dark.org.http.impl.nio.reactor.SSLIOSession;
import dark.org.http.impl.nio.reactor.SSLIOSessionHandler;
import dark.org.http.impl.nio.reactor.SSLMode;
import dark.org.http.nio.NHttpClientConnection;
import dark.org.http.nio.NHttpClientHandler;
import dark.org.http.nio.NHttpClientIOTarget;
import dark.org.http.nio.reactor.IOEventDispatch;
import dark.org.http.nio.reactor.IOSession;
import dark.org.http.nio.util.ByteBufferAllocator;
import dark.org.http.nio.util.HeapByteBufferAllocator;
import dark.org.http.params.HttpParams;
import dark.org.http.util.Args;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;

@Deprecated
public class SSLClientIOEventDispatch
implements IOEventDispatch {
    private static final String SSL_SESSION = "SSL_SESSION";
    protected final NHttpClientHandler handler;
    protected final SSLContext sslcontext;
    protected final SSLIOSessionHandler sslHandler;
    protected final HttpParams params;

    public SSLClientIOEventDispatch(NHttpClientHandler handler, SSLContext sslContext, SSLIOSessionHandler sslHandler, HttpParams params) {
        Args.notNull(handler, "HTTP client handler");
        Args.notNull(sslContext, "SSL context");
        Args.notNull(params, "HTTP parameters");
        this.handler = handler;
        this.params = params;
        this.sslcontext = sslContext;
        this.sslHandler = sslHandler;
    }

    public SSLClientIOEventDispatch(NHttpClientHandler handler, SSLContext sslContext, HttpParams params) {
        this(handler, sslContext, null, params);
    }

    protected ByteBufferAllocator createByteBufferAllocator() {
        return HeapByteBufferAllocator.INSTANCE;
    }

    protected HttpResponseFactory createHttpResponseFactory() {
        return DefaultHttpResponseFactory.INSTANCE;
    }

    protected NHttpClientIOTarget createConnection(IOSession session) {
        return new DefaultNHttpClientConnection(session, this.createHttpResponseFactory(), this.createByteBufferAllocator(), this.params);
    }

    protected SSLIOSession createSSLIOSession(IOSession session, SSLContext sslContext, SSLIOSessionHandler sslHandler) {
        return new SSLIOSession(session, sslContext, sslHandler);
    }

    @Override
    public void connected(IOSession session) {
        SSLIOSession sslSession = this.createSSLIOSession(session, this.sslcontext, this.sslHandler);
        NHttpClientIOTarget conn = this.createConnection(sslSession);
        session.setAttribute("http.connection", conn);
        session.setAttribute(SSL_SESSION, sslSession);
        Object attachment = session.getAttribute("http.session.attachment");
        this.handler.connected(conn, attachment);
        try {
            sslSession.bind(SSLMode.CLIENT, this.params);
        }
        catch (SSLException ex) {
            this.handler.exception((NHttpClientConnection)conn, ex);
            sslSession.shutdown();
        }
    }

    @Override
    public void disconnected(IOSession session) {
        NHttpClientIOTarget conn = (NHttpClientIOTarget)session.getAttribute("http.connection");
        if (conn != null) {
            this.handler.closed(conn);
        }
    }

    @Override
    public void inputReady(IOSession session) {
        NHttpClientIOTarget conn = (NHttpClientIOTarget)session.getAttribute("http.connection");
        SSLIOSession sslSession = (SSLIOSession)session.getAttribute(SSL_SESSION);
        try {
            if (sslSession.isAppInputReady()) {
                conn.consumeInput(this.handler);
            }
            sslSession.inboundTransport();
        }
        catch (IOException ex) {
            this.handler.exception((NHttpClientConnection)conn, ex);
            sslSession.shutdown();
        }
    }

    @Override
    public void outputReady(IOSession session) {
        NHttpClientIOTarget conn = (NHttpClientIOTarget)session.getAttribute("http.connection");
        SSLIOSession sslSession = (SSLIOSession)session.getAttribute(SSL_SESSION);
        try {
            if (sslSession.isAppOutputReady()) {
                conn.produceOutput(this.handler);
            }
            sslSession.outboundTransport();
        }
        catch (IOException ex) {
            this.handler.exception((NHttpClientConnection)conn, ex);
            sslSession.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeout(IOSession session) {
        NHttpClientIOTarget conn = (NHttpClientIOTarget)session.getAttribute("http.connection");
        SSLIOSession sslSession = (SSLIOSession)session.getAttribute(SSL_SESSION);
        this.handler.timeout(conn);
        SSLIOSession sSLIOSession = sslSession;
        synchronized (sSLIOSession) {
            if (sslSession.isOutboundDone() && !sslSession.isInboundDone()) {
                sslSession.shutdown();
            }
        }
    }
}

