/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.impl.nio;

import dark.org.http.HttpRequest;
import dark.org.http.HttpRequestFactory;
import dark.org.http.HttpResponse;
import dark.org.http.annotation.Contract;
import dark.org.http.annotation.ThreadingBehavior;
import dark.org.http.config.ConnectionConfig;
import dark.org.http.entity.ContentLengthStrategy;
import dark.org.http.impl.ConnSupport;
import dark.org.http.impl.DefaultHttpRequestFactory;
import dark.org.http.impl.nio.DefaultNHttpServerConnection;
import dark.org.http.impl.nio.codecs.DefaultHttpRequestParserFactory;
import dark.org.http.nio.NHttpConnectionFactory;
import dark.org.http.nio.NHttpMessageParserFactory;
import dark.org.http.nio.NHttpMessageWriterFactory;
import dark.org.http.nio.reactor.IOSession;
import dark.org.http.nio.util.ByteBufferAllocator;
import dark.org.http.nio.util.HeapByteBufferAllocator;
import dark.org.http.params.HttpParamConfig;
import dark.org.http.params.HttpParams;
import dark.org.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultNHttpServerConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpServerConnection> {
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final NHttpMessageParserFactory<HttpRequest> requestParserFactory;
    private final NHttpMessageWriterFactory<HttpResponse> responseWriterFactory;
    private final ByteBufferAllocator allocator;
    private final ConnectionConfig cconfig;

    @Deprecated
    public DefaultNHttpServerConnectionFactory(HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        Args.notNull(requestFactory, "HTTP request factory");
        Args.notNull(allocator, "Byte buffer allocator");
        Args.notNull(params, "HTTP parameters");
        this.incomingContentStrategy = null;
        this.outgoingContentStrategy = null;
        this.requestParserFactory = new DefaultHttpRequestParserFactory(null, requestFactory);
        this.responseWriterFactory = null;
        this.allocator = allocator;
        this.cconfig = HttpParamConfig.getConnectionConfig(params);
    }

    @Deprecated
    public DefaultNHttpServerConnectionFactory(HttpParams params) {
        this(DefaultHttpRequestFactory.INSTANCE, HeapByteBufferAllocator.INSTANCE, params);
    }

    @Deprecated
    protected DefaultNHttpServerConnection createConnection(IOSession session, HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        return new DefaultNHttpServerConnection(session, requestFactory, allocator, params);
    }

    public DefaultNHttpServerConnectionFactory(ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, NHttpMessageParserFactory<HttpRequest> requestParserFactory, NHttpMessageWriterFactory<HttpResponse> responseWriterFactory, ByteBufferAllocator allocator, ConnectionConfig cconfig) {
        this.incomingContentStrategy = incomingContentStrategy;
        this.outgoingContentStrategy = outgoingContentStrategy;
        this.requestParserFactory = requestParserFactory;
        this.responseWriterFactory = responseWriterFactory;
        this.allocator = allocator;
        this.cconfig = cconfig != null ? cconfig : ConnectionConfig.DEFAULT;
    }

    public DefaultNHttpServerConnectionFactory(ByteBufferAllocator allocator, NHttpMessageParserFactory<HttpRequest> requestParserFactory, NHttpMessageWriterFactory<HttpResponse> responseWriterFactory, ConnectionConfig cconfig) {
        this(null, null, requestParserFactory, responseWriterFactory, allocator, cconfig);
    }

    public DefaultNHttpServerConnectionFactory(ConnectionConfig config) {
        this(null, null, null, null, null, config);
    }

    public DefaultNHttpServerConnectionFactory() {
        this(null, null, null, null, null, null);
    }

    @Override
    public DefaultNHttpServerConnection createConnection(IOSession session) {
        return new DefaultNHttpServerConnection(session, this.cconfig.getBufferSize(), this.cconfig.getFragmentSizeHint(), this.allocator, ConnSupport.createDecoder(this.cconfig), ConnSupport.createEncoder(this.cconfig), this.cconfig.getMessageConstraints(), this.incomingContentStrategy, this.outgoingContentStrategy, this.requestParserFactory, this.responseWriterFactory);
    }
}

