/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.impl.cookie;

import dark.org.http.annotation.Contract;
import dark.org.http.annotation.ThreadingBehavior;
import dark.org.http.cookie.Cookie;
import dark.org.http.cookie.CookieOrigin;
import dark.org.http.cookie.CookieRestrictionViolationException;
import dark.org.http.cookie.MalformedCookieException;
import dark.org.http.cookie.SetCookie;
import dark.org.http.impl.cookie.BasicDomainHandler;
import dark.org.http.util.Args;
import dark.org.http.util.TextUtils;
import java.util.Locale;
import java.util.StringTokenizer;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class NetscapeDomainHandler
extends BasicDomainHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (TextUtils.isBlank(value)) {
            throw new MalformedCookieException("Blank or null value for domain attribute");
        }
        cookie.setDomain(value);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        String domain;
        String host = origin.getHost();
        if (!host.equals(domain = cookie.getDomain()) && !BasicDomainHandler.domainMatch(domain, host)) {
            throw new CookieRestrictionViolationException("Illegal domain attribute \"" + domain + "\". Domain of origin: \"" + host + "\"");
        }
        if (host.contains(".")) {
            int domainParts = new StringTokenizer(domain, ".").countTokens();
            if (NetscapeDomainHandler.isSpecialDomain(domain)) {
                if (domainParts < 2) {
                    throw new CookieRestrictionViolationException("Domain attribute \"" + domain + "\" violates the Netscape cookie specification for " + "special domains");
                }
            } else if (domainParts < 3) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + domain + "\" violates the Netscape cookie specification");
            }
        }
    }

    private static boolean isSpecialDomain(String domain) {
        String ucDomain = domain.toUpperCase(Locale.ROOT);
        return ucDomain.endsWith(".COM") || ucDomain.endsWith(".EDU") || ucDomain.endsWith(".NET") || ucDomain.endsWith(".GOV") || ucDomain.endsWith(".MIL") || ucDomain.endsWith(".ORG") || ucDomain.endsWith(".INT");
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        String host = origin.getHost();
        String domain = cookie.getDomain();
        if (domain == null) {
            return false;
        }
        return host.endsWith(domain);
    }

    @Override
    public String getAttributeName() {
        return "domain";
    }
}

