/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.impl.conn;

import dark.org.http.HttpException;
import dark.org.http.HttpHost;
import dark.org.http.HttpRequest;
import dark.org.http.ProtocolException;
import dark.org.http.annotation.Contract;
import dark.org.http.annotation.ThreadingBehavior;
import dark.org.http.client.config.RequestConfig;
import dark.org.http.client.protocol.HttpClientContext;
import dark.org.http.conn.SchemePortResolver;
import dark.org.http.conn.UnsupportedSchemeException;
import dark.org.http.conn.routing.HttpRoute;
import dark.org.http.conn.routing.HttpRoutePlanner;
import dark.org.http.impl.conn.DefaultSchemePortResolver;
import dark.org.http.protocol.HttpContext;
import dark.org.http.util.Args;
import java.net.InetAddress;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    @Override
    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        Args.notNull(request, "Request");
        if (host == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        InetAddress local = config.getLocalAddress();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, request, context);
        }
        if (host.getPort() <= 0) {
            try {
                target = new HttpHost(host.getHostName(), this.schemePortResolver.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        return proxy == null ? new HttpRoute(target, local, secure) : new HttpRoute(target, local, proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return null;
    }
}

