/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils;

import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.CustomFakePlayer;
import com.darkere.crashutils.DataStructures.TileEntityData;
import com.darkere.crashutils.Network.Network;
import com.darkere.crashutils.Network.NetworkTools;
import com.darkere.crashutils.Network.RemoveEntitiesMessage;
import com.darkere.crashutils.Network.RemoveEntityMessage;
import com.darkere.crashutils.Network.TeleportMessage;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class WorldUtils {
    public static List<ServerWorld> getWorldsFromDimensionArgument(CommandContext<CommandSource> context) {
        ServerWorld world = null;
        try {
            world = DimensionArgument.func_212592_a(context, (String)"dim");
        }
        catch (CommandSyntaxException | IllegalArgumentException throwable) {
            // empty catch block
        }
        ArrayList<ServerWorld> worlds = new ArrayList<ServerWorld>();
        if (world == null) {
            ((CommandSource)context.getSource()).func_197028_i().func_212370_w().forEach(worlds::add);
        } else {
            worlds.add(world);
        }
        return worlds;
    }

    public static void teleportPlayer(PlayerEntity player, World startWorld, World destWorld, BlockPos newPos) {
        if (player.field_70170_p.field_72995_K) {
            Network.sendToServer(new TeleportMessage((RegistryKey<World>)startWorld.func_234923_W_(), (RegistryKey<World>)destWorld.func_234923_W_(), newPos));
        }
        if (newPos.func_177956_o() == 0) {
            Chunk chunk = destWorld.func_175726_f(newPos);
            int y = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, newPos.func_177958_n(), newPos.func_177952_p());
            newPos = new BlockPos(newPos.func_177958_n(), y, newPos.func_177952_p());
        }
        if (startWorld != destWorld) {
            final BlockPos finalNewPos = newPos;
            player.changeDimension((ServerWorld)destWorld, new ITeleporter(){

                public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                    Entity entity1 = repositionEntity.apply(false);
                    entity1.func_70634_a((double)finalNewPos.func_177958_n(), (double)(finalNewPos.func_177956_o() + 1), (double)finalNewPos.func_177952_p());
                    return entity1;
                }
            });
        } else {
            player.func_70634_a((double)newPos.func_177958_n(), (double)(newPos.func_177956_o() + 1), (double)newPos.func_177952_p());
        }
    }

    public static boolean applyToPlayer(String playerName, MinecraftServer server, Consumer<ServerPlayerEntity> consumer) {
        ServerPlayerEntity player = server.func_184103_al().func_152612_a(playerName);
        if (player == null) {
            GameProfile profile = server.func_152358_ax().func_152655_a(playerName);
            if (profile == null) {
                return false;
            }
            CustomFakePlayer fakePlayer = new CustomFakePlayer(server.func_71218_a(World.field_234918_g_), profile);
            CompoundNBT nbt = server.field_240766_e_.func_237336_b_((PlayerEntity)fakePlayer);
            if (nbt == null) {
                return false;
            }
            fakePlayer.func_70020_e(nbt);
            consumer.accept((ServerPlayerEntity)fakePlayer);
            server.field_240766_e_.func_237335_a_((PlayerEntity)fakePlayer);
        } else {
            consumer.accept(player);
        }
        return true;
    }

    public static BlockPos getChunkCenter(ChunkPos pos) {
        int x = pos.func_180334_c() + 8;
        int z = pos.func_180333_d() + 8;
        return new BlockPos(x, 0, z);
    }

    public static void removeEntity(World world, UUID id, boolean force) {
        if (NetworkTools.returnOnNull(world, id)) {
            return;
        }
        if (world.field_72995_K) {
            Network.sendToServer(new RemoveEntityMessage((RegistryKey<World>)world.func_234923_W_(), id, false, force));
            return;
        }
        Entity e = ((ServerWorld)world).func_217461_a(id);
        if (e == null) {
            return;
        }
        if (force) {
            ((ServerWorld)world).removeEntityComplete(e, false);
        } else {
            e.func_70106_y();
        }
    }

    public static void removeEntityType(World world, ResourceLocation rl, boolean force) {
        if (NetworkTools.returnOnNull(world, rl)) {
            return;
        }
        if (world.field_72995_K) {
            Network.sendToServer(new RemoveEntitiesMessage((RegistryKey<World>)world.func_234923_W_(), rl, null, false, force));
            return;
        }
        ((ServerWorld)world).getEntities().filter(entity -> Objects.equals(entity.func_200600_R().getRegistryName(), rl)).forEach(e -> {
            if (force) {
                ((ServerWorld)world).removeEntityComplete(e, false);
            } else {
                e.func_70106_y();
            }
        });
    }

    public static void removeEntitiesInChunk(World world, ChunkPos pos, ResourceLocation rl, boolean force) {
        if (NetworkTools.returnOnNull(world, pos, rl)) {
            return;
        }
        if (world.field_72995_K) {
            Network.sendToServer(new RemoveEntitiesMessage((RegistryKey<World>)world.func_234923_W_(), rl, pos, false, force));
            return;
        }
        Vector3d start = new Vector3d((double)pos.func_180334_c(), 0.0, (double)pos.func_180333_d());
        Vector3d end = new Vector3d((double)pos.func_180332_e(), 255.0, (double)pos.func_180330_f());
        world.func_175674_a((Entity)null, new AxisAlignedBB(start, end), entity -> Objects.equals(entity.func_200600_R().getRegistryName(), rl)).forEach(e -> {
            if (force) {
                ((ServerWorld)world).removeEntityComplete(e, false);
            } else {
                e.func_70106_y();
            }
        });
    }

    public static void removeTileEntity(World world, UUID id, boolean force) {
        if (NetworkTools.returnOnNull(world, id)) {
            return;
        }
        if (world.field_72995_K) {
            Network.sendToServer(new RemoveEntityMessage((RegistryKey<World>)world.func_234923_W_(), id, true, force));
            return;
        }
        CrashUtils.runNextTick(wld -> {
            if (force) {
                world.func_175713_t(TileEntityData.TEID.get((Object)id).pos);
                world.func_217377_a(TileEntityData.TEID.get((Object)id).pos, false);
            } else {
                world.func_175713_t(TileEntityData.TEID.get((Object)id).pos);
            }
        });
    }

    public static void removeTileEntityType(World world, ResourceLocation rl, boolean force) {
        if (NetworkTools.returnOnNull(world, rl)) {
            return;
        }
        if (world.field_72995_K) {
            Network.sendToServer(new RemoveEntitiesMessage((RegistryKey<World>)world.func_234923_W_(), rl, null, true, force));
            return;
        }
        for (TileEntity te : world.field_147482_g) {
            if (te.func_200662_C().getRegistryName() == null || !Objects.equals(te.func_200662_C().getRegistryName(), rl)) continue;
            CrashUtils.runNextTick(wld -> {
                if (force) {
                    world.func_175713_t(te.func_174877_v());
                    world.func_217377_a(te.func_174877_v(), false);
                } else {
                    world.func_175713_t(te.func_174877_v());
                }
            });
        }
    }

    public static void removeTileEntitiesInChunk(World world, ChunkPos pos, ResourceLocation rl, boolean force) {
        if (NetworkTools.returnOnNull(world, pos, rl)) {
            return;
        }
        if (world.field_72995_K) {
            Network.sendToServer(new RemoveEntitiesMessage((RegistryKey<World>)world.func_234923_W_(), rl, pos, true, force));
            return;
        }
        Vector3d start = new Vector3d((double)pos.func_180334_c(), 0.0, (double)pos.func_180333_d());
        Vector3d end = new Vector3d((double)pos.func_180332_e(), 255.0, (double)pos.func_180330_f());
        world.field_147482_g.stream().filter(te -> Objects.equals(te.func_200662_C().getRegistryName(), rl) && new AxisAlignedBB(start, end).func_72318_a(Vector3d.func_237489_a_((Vector3i)te.func_174877_v()))).forEach(te -> CrashUtils.runNextTick(wld -> {
            if (force) {
                world.func_175713_t(te.func_174877_v());
                world.func_217377_a(te.func_174877_v(), false);
            } else {
                world.func_175713_t(te.func_174877_v());
            }
        }));
    }
}

