/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Screens;

import com.darkere.crashutils.Screens.CUScreen;
import com.darkere.crashutils.Screens.FillMany;
import com.darkere.crashutils.Screens.GuiTools;
import com.darkere.crashutils.Screens.Types.DropDownType;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.StringUtils;

public class CUDropDown
extends AbstractGui {
    private List<String> allOptions;
    private List<String> options = new ArrayList<String>();
    private String selected = "";
    private int posX;
    private int posY;
    private int width;
    private boolean expanded;
    private boolean alwaysExpanded;
    private List<FillMany.Text> strings;
    private final int height = 11;
    final TextFieldWidget widget;
    private boolean isEnabled = false;
    String oldFilter = "";
    CUScreen parent;
    DropDownType type;
    int fitOnScreen = 17;
    private int currentOffset = 0;
    private int maxOffset;
    private boolean variableLength = false;
    private final int defaultXRenderOffset;
    private final int defaultYRenderOffset;
    boolean sortByname = false;
    boolean allOption;

    public CUDropDown(DropDownType type, CUScreen parent, List<String> options, String selected, int defaultXRenderOffset, int defaultYRenderOffset, int width) {
        this.type = type;
        this.parent = parent;
        if (options == null) {
            options = new ArrayList<String>();
        }
        this.allOptions = options;
        if (!this.allOptions.contains(selected)) {
            this.allOptions.add(selected);
        }
        this.selected = selected;
        this.allOption = selected.equals("all");
        this.defaultXRenderOffset = defaultXRenderOffset;
        this.defaultYRenderOffset = defaultYRenderOffset;
        this.posX = parent.centerX + defaultXRenderOffset + 1;
        this.posY = parent.centerY + defaultYRenderOffset + 1;
        this.options.addAll(options);
        this.options.remove(selected);
        if (width == 0) {
            this.variableLength = true;
            this.updateWidth();
        } else {
            this.width = width;
        }
        this.widget = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, this.posX, this.posY, this.width, 11, (ITextComponent)new StringTextComponent(selected));
        this.widget.func_146180_a(selected);
        this.widget.func_146196_d();
        this.maxOffset = options.size() - this.fitOnScreen;
        if (this.maxOffset < 0) {
            this.maxOffset = 0;
        }
    }

    public void setFitOnScreen(int fitOnScreen) {
        this.fitOnScreen = fitOnScreen;
    }

    public void render(MatrixStack stack, int centerX, int centerY) {
        this.posX = centerX + this.defaultXRenderOffset + 1;
        this.posY = centerY + this.defaultYRenderOffset + 1;
        if (!this.isEnabled) {
            return;
        }
        ArrayList<FillMany.ColoredRectangle> list = new ArrayList<FillMany.ColoredRectangle>();
        this.strings = new ArrayList<FillMany.Text>();
        this.widget.func_230430_a_(stack, this.posX, this.posY, 0.0f);
        if (this.expanded) {
            boolean colored = false;
            int fits = Math.min(this.fitOnScreen, this.options.size());
            list.add(new FillMany.ColoredRectangle(this.posX - 1, this.posY, this.posX, this.posY + fits * 11 + 11, -6250336));
            list.add(new FillMany.ColoredRectangle(this.posX + this.width, this.posY, this.posX + this.width + 1, this.posY + fits * 11 + 11, -6250336));
            if (this.maxOffset > 0) {
                float percent = (float)this.currentOffset / (float)this.maxOffset;
                int pos = (int)(percent * (float)(11 * fits - 11));
                list.add(new FillMany.ColoredRectangle(this.posX + this.width, this.posY + 11 + pos, this.posX + this.width + 1, this.posY + 11 + pos + 11, -1));
            }
            for (int i = 0; i < fits; ++i) {
                list.add(new FillMany.ColoredRectangle(this.posX, this.posY + (i + 1) * 11, this.posX + this.width, this.posY + (i + 1) * 11 + 11, colored ? -9934744 : -5723992));
                this.strings.add(new FillMany.Text(this.posX + 4, this.posY + (i + 1) * 11 + 2, this.options.get(i + this.currentOffset), -1));
                colored = !colored;
            }
        }
        FillMany.fillMany(TransformationMatrix.func_227983_a_().func_227988_c_(), list);
        FillMany.drawStrings(stack, Minecraft.func_71410_x().field_71466_p, this.strings);
    }

    public void setSortByName(boolean sortByname) {
        this.sortByname = sortByname;
    }

    public void updateFilter() {
        if (!this.isEnabled) {
            return;
        }
        String f = this.widget.func_146179_b();
        this.options.clear();
        this.options.addAll(this.allOptions);
        if (this.allOption) {
            this.options.add("all");
        }
        if (!f.equals("all")) {
            this.options.removeIf(option -> {
                if (option.startsWith("[")) {
                    option = option.substring(option.indexOf("]") + 2);
                }
                return !option.startsWith(f) && !StringUtils.substringAfter((String)option, (String)":").startsWith(f);
            });
        }
        this.maxOffset = this.options.size() - this.fitOnScreen;
        if (this.sortByname) {
            this.options.sort(String::compareTo);
        }
        if (this.maxOffset < 0) {
            this.maxOffset = 0;
        }
        if (this.currentOffset > this.maxOffset) {
            this.currentOffset = this.maxOffset;
        }
        if (this.variableLength) {
            this.updateWidth();
        }
    }

    public void setAlwaysExpanded() {
        this.alwaysExpanded = true;
        this.setFitOnScreen(16);
        this.setSortByName(false);
        this.setExpanded(true);
    }

    private void updateWidth() {
        if (!this.allOptions.isEmpty()) {
            String longest = this.allOptions.stream().max(Comparator.comparingInt(String::length)).orElseGet(() -> "minecraft:baselength");
            this.width = Minecraft.func_71410_x().field_71466_p.func_78256_a(longest) + 4;
        } else {
            this.width = 30;
        }
        if (this.widget != null) {
            this.widget.func_230991_b_(this.width);
        }
    }

    public void updateOptions(List<String> strings) {
        this.allOptions = strings;
        this.updateFilter();
    }

    public void setFilter(String filter) {
        this.widget.func_146180_a(filter);
        this.updateFilter();
    }

    public void setExpanded(boolean expanded) {
        if (!this.alwaysExpanded) {
            this.expanded = expanded;
            this.widget.func_146195_b(expanded);
            this.widget.func_146184_c(expanded);
        } else {
            this.expanded = true;
            this.widget.func_146195_b(true);
            this.widget.func_146184_c(true);
        }
    }

    public boolean isMouseOver(int mx, int my) {
        return GuiTools.inArea(mx, my, this.posX, this.posY + 11, this.posX + this.width, this.posY + this.strings.size() * 11 + 11);
    }

    public boolean checkClick(int x, int y) {
        if (!this.isEnabled) {
            return false;
        }
        if (this.alwaysExpanded && GuiTools.inArea(x, y, this.posX, this.posY, this.posX + this.width, this.posY + 11)) {
            this.setExpanded(true);
            this.oldFilter = this.widget.func_146179_b();
            this.widget.func_146180_a("");
            this.updateFilter();
        }
        if (this.expanded) {
            if (!GuiTools.inArea(x, y, this.posX, this.posY + 11, this.posX + this.width, this.posY + this.strings.size() * 11 + 11)) {
                this.setExpanded(false);
                this.currentOffset = 0;
                if (this.widget.func_146179_b().isEmpty()) {
                    this.widget.func_146180_a(this.oldFilter);
                }
                return !this.alwaysExpanded;
            }
            int se = y - this.posY;
            if (this.options.size() >= (se /= 11)) {
                if (!this.alwaysExpanded) {
                    if (!this.selected.isEmpty()) {
                        this.options.add(this.selected);
                    }
                    this.selected = this.options.get(se - 1 + this.currentOffset);
                    this.widget.func_146180_a(this.selected);
                    this.options.remove(this.selected);
                    this.parent.updateSelection(this.type, this.selected);
                } else {
                    this.parent.updateSelection(this.type, this.options.get(se - 1));
                }
                this.setExpanded(false);
                this.currentOffset = 0;
                return true;
            }
        } else if (GuiTools.inArea(x, y, this.posX, this.posY, this.posX + this.width, this.posY + 11)) {
            this.setExpanded(true);
            this.oldFilter = this.widget.func_146179_b();
            this.widget.func_146180_a("");
            this.updateFilter();
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public boolean scroll(double mx, double my, double delta) {
        if (!this.isEnabled) {
            return false;
        }
        if (GuiTools.inArea((int)mx, (int)my, this.posX, this.posY + 11, this.posX + this.width, this.posY + this.strings.size() * 11 + 11)) {
            if (this.maxOffset > 0) {
                if (delta < 0.0) {
                    if (this.currentOffset < this.maxOffset) {
                        ++this.currentOffset;
                    }
                } else if (this.currentOffset > 0) {
                    --this.currentOffset;
                }
            }
            return true;
        }
        return false;
    }
}

