/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.DataStructures.EntityData;
import com.darkere.crashutils.DataStructures.LoadedChunkData;
import com.darkere.crashutils.DataStructures.PlayerData;
import com.darkere.crashutils.DataStructures.TileEntityData;
import com.darkere.crashutils.Network.DataRequestType;
import com.darkere.crashutils.Network.EntityDataMessage;
import com.darkere.crashutils.Network.LoadedChunkDataStateMessage;
import com.darkere.crashutils.Network.LoadedChunkDataTicketsMessage;
import com.darkere.crashutils.Network.Network;
import com.darkere.crashutils.Network.NetworkTools;
import com.darkere.crashutils.Network.PlayerDataMessage;
import com.darkere.crashutils.Network.TileEntityDataMessage;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateDataRequestMessage {
    private DataRequestType type;
    private RegistryKey<World> worldKey;

    public UpdateDataRequestMessage(DataRequestType type, RegistryKey<World> worldKey) {
        this.type = type;
        this.worldKey = worldKey;
    }

    public static void encode(UpdateDataRequestMessage data, PacketBuffer buf) {
        buf.writeInt(data.type.ordinal());
        NetworkTools.writeWorldKey(data.worldKey, buf);
    }

    public static UpdateDataRequestMessage decode(PacketBuffer buf) {
        return new UpdateDataRequestMessage(DataRequestType.values()[buf.readInt()], NetworkTools.readWorldKey(buf));
    }

    public static void handle(UpdateDataRequestMessage data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                return;
            }
            if (!((NetworkEvent.Context)ctx.get()).getSender().func_211513_k(2)) {
                return;
            }
            MinecraftServer server = ((NetworkEvent.Context)ctx.get()).getSender().func_184102_h();
            if (server == null) {
                return;
            }
            ServerWorld world = server.func_71218_a(data.worldKey);
            List<ServerWorld> worlds = Collections.singletonList(world);
            switch (data.type) {
                case LOADEDCHUNKDATA: {
                    LoadedChunkData loadedChunkData = new LoadedChunkData(worlds);
                    CrashUtils.runNextTick(arg_0 -> UpdateDataRequestMessage.lambda$null$0((Supplier)ctx, loadedChunkData, arg_0));
                    CrashUtils.runNextTick(arg_0 -> UpdateDataRequestMessage.lambda$null$1((Supplier)ctx, loadedChunkData, arg_0));
                    break;
                }
                case ENTITYDATA: {
                    EntityData entityData = new EntityData();
                    entityData.createLists(worlds);
                    Network.sendToPlayer(((NetworkEvent.Context)ctx.get()).getSender(), new EntityDataMessage(entityData));
                    break;
                }
                case TILEENTITYDATA: {
                    TileEntityData tileEntityData = new TileEntityData();
                    tileEntityData.createLists(worlds);
                    Network.sendToPlayer(((NetworkEvent.Context)ctx.get()).getSender(), new TileEntityDataMessage(tileEntityData));
                    break;
                }
                case PLAYERDATA: {
                    PlayerData playerData = new PlayerData();
                    playerData.createLists(worlds);
                    Network.sendToPlayer(((NetworkEvent.Context)ctx.get()).getSender(), new PlayerDataMessage(playerData));
                    break;
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$null$1(Supplier ctx, LoadedChunkData loadedChunkData, ServerWorld lc) {
        Network.sendToPlayer(((NetworkEvent.Context)ctx.get()).getSender(), new LoadedChunkDataTicketsMessage(loadedChunkData.getChunksByTicketName()));
    }

    private static /* synthetic */ void lambda$null$0(Supplier ctx, LoadedChunkData loadedChunkData, ServerWorld lc) {
        Network.sendToPlayer(((NetworkEvent.Context)ctx.get()).getSender(), new LoadedChunkDataStateMessage(loadedChunkData.getChunksByLocationType()));
    }
}

