/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.Network.NetworkTools;
import com.darkere.crashutils.WorldUtils;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class RemoveEntityMessage {
    RegistryKey<World> worldRegistryKey;
    UUID id;
    boolean tile;
    boolean force;

    public RemoveEntityMessage(RegistryKey<World> worldRegistryKey, UUID id, boolean tile, boolean force) {
        this.worldRegistryKey = worldRegistryKey;
        this.id = id;
        this.tile = tile;
        this.force = force;
    }

    public static void encode(RemoveEntityMessage data, PacketBuffer buf) {
        NetworkTools.writeWorldKey(data.worldRegistryKey, buf);
        buf.func_179252_a(data.id);
        buf.writeBoolean(data.tile);
        buf.writeBoolean(data.force);
    }

    public static RemoveEntityMessage decode(PacketBuffer buf) {
        return new RemoveEntityMessage(NetworkTools.readWorldKey(buf), buf.func_179253_g(), buf.readBoolean(), buf.readBoolean());
    }

    public static boolean handle(RemoveEntityMessage data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null || !player.func_211513_k(2)) {
                return;
            }
            if (data.tile) {
                WorldUtils.removeTileEntity((World)player.func_184102_h().func_71218_a(data.worldRegistryKey), data.id, data.force);
            } else {
                WorldUtils.removeEntity((World)player.func_184102_h().func_71218_a(data.worldRegistryKey), data.id, data.force);
            }
        });
        return true;
    }
}

