/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils;

import fr.minuskube.pastee.JPastee;
import fr.minuskube.pastee.data.Paste;
import fr.minuskube.pastee.data.Section;
import fr.minuskube.pastee.response.SubmitResponse;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;

public class LogHandler {
    private static final JPastee pastee = new JPastee("aleMUU8QFQiuh9q9UnK737FoM5v08v2cZOkl1f1p7");
    public static final Path latestlog = Paths.get("logs/latest.log", new String[0]);

    public static String uploadLog(String description, String name, String content) {
        Paste.Builder paste = Paste.builder();
        paste.description(description);
        paste.addSection(Section.builder().name(name).contents(content).build());
        SubmitResponse resp = pastee.submit(paste.build());
        if (resp.isSuccess()) {
            return resp.getLink();
        }
        return resp.getErrorString();
    }

    public static String getRelativePathDateInMin(Path path) {
        long last = path.toFile().lastModified();
        last = Instant.now().getEpochSecond() - last / 1000L;
        return Long.toString(last / 60L);
    }

    public static Path getLatestCrashReportPath() {
        Optional<Object> lastFilePath = Optional.empty();
        try {
            lastFilePath = Files.list(Paths.get("crash-reports/", new String[0])).filter(f -> !Files.isDirectory(f, new LinkOption[0])).max(Comparator.comparingLong(f -> f.toFile().lastModified()));
        }
        catch (IOException e) {
            return null;
        }
        return lastFilePath.orElse(null);
    }

    public static String getFileAsStringFromPath(Path path) {
        List<String> strings = new ArrayList<String>(Collections.singletonList(""));
        try {
            strings = Files.readAllLines(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return String.join((CharSequence)System.lineSeparator(), strings);
    }

    public static String getStringFromArchive(Path path) {
        GZIPInputStream gzip = null;
        try {
            gzip = new GZIPInputStream(new FileInputStream(String.valueOf(path)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(gzip));
        List strings = br.lines().collect(Collectors.toList());
        return String.join((CharSequence)System.lineSeparator(), strings);
    }

    public static Path getLatestArchivedLogPath() {
        Optional<Object> lastFilePath = Optional.empty();
        try {
            lastFilePath = Files.list(Paths.get("logs/", new String[0])).filter(f -> !Files.isDirectory(f, new LinkOption[0]) && f.toFile().getName().endsWith(".gz")).max(Comparator.comparingLong(f -> f.toFile().lastModified()));
        }
        catch (IOException e) {
            return null;
        }
        return lastFilePath.orElse(null);
    }
}

