/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.DataStructures;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.DataStructures.LocationData;
import com.darkere.crashutils.DataStructures.WorldPos;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class TileEntityData
extends LocationData {
    Map<ResourceLocation, Boolean> tickmap = new HashMap<ResourceLocation, Boolean>();
    public static Map<UUID, WorldPos> TEID = new HashMap<UUID, WorldPos>();
    int totalticking = 0;

    public TileEntityData() {
        for (Map.Entry entry : ForgeRegistries.TILE_ENTITIES.getEntries()) {
            this.map.put(((RegistryKey)entry.getKey()).func_240901_a_(), new ArrayList());
        }
    }

    public TileEntityData(Map<ResourceLocation, List<WorldPos>> map) {
        this.map = map;
    }

    public void createLists(List<ServerWorld> worlds) {
        ArrayList tileEntities = new ArrayList();
        ArrayList ticking = new ArrayList();
        worlds.forEach(x -> tileEntities.addAll(x.field_147482_g));
        worlds.forEach(x -> ticking.addAll(x.field_175730_i));
        for (TileEntity tileEntity : tileEntities) {
            WorldPos pos = WorldPos.getPosFromTileEntity(tileEntity);
            if (pos == null) continue;
            TEID.put(pos.getID(), pos);
            ((List)this.map.get(tileEntity.func_200662_C().getRegistryName())).add(pos);
        }
        this.total = tileEntities.size();
        for (TileEntity tileEntity : ticking) {
            this.tickmap.put(tileEntity.func_200662_C().getRegistryName(), true);
        }
        this.totalticking = ticking.size();
    }

    public void reply(ResourceLocation res, CommandSource source) {
        if (res == null) {
            this.map.entrySet().stream().filter(x -> ((List)x.getValue()).size() != 0).sorted(Comparator.comparingInt(e -> ((List)e.getValue()).size())).forEach(e -> CommandUtils.sendFindTEMessage(source, (ResourceLocation)e.getKey(), ((List)e.getValue()).size(), this.tickmap.containsKey(e.getKey())));
            CommandUtils.sendNormalMessage(source, this.total + " TE's , " + this.totalticking + "ticking", TextFormatting.DARK_AQUA);
        } else {
            ((List)this.map.get(res)).forEach(x -> CommandUtils.sendTEMessage(source, x, true));
        }
    }
}

