/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.DataStructures;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.Screens.CUOption;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.Ticket;
import net.minecraft.world.server.TicketManager;

public class LoadedChunkData {
    Map<String, Set<ChunkPos>> chunksByTicketName = new HashMap<String, Set<ChunkPos>>();
    Map<String, Set<ChunkPos>> chunksByLocationType = new HashMap<String, Set<ChunkPos>>();
    Map<ChunkPos, Set<String>> ticketsByChunk = new HashMap<ChunkPos, Set<String>>();
    Map<ChunkPos, String> locationTypeByChunk = new HashMap<ChunkPos, String>();
    Map<String, LocationTickets> ticketsByLocation = new HashMap<String, LocationTickets>();
    int total = 0;

    public Map<String, Set<ChunkPos>> getChunksByTicketName() {
        return this.chunksByTicketName;
    }

    public Map<String, Set<ChunkPos>> getChunksByLocationType() {
        return this.chunksByLocationType;
    }

    public LoadedChunkData(Map<String, Set<ChunkPos>> chunksByTicketName, Map<String, Set<ChunkPos>> chunksByLocationType) {
        this.chunksByTicketName = chunksByTicketName;
        this.chunksByLocationType = chunksByLocationType;
    }

    public LoadedChunkData(List<ServerWorld> worlds) {
        CrashUtils.runNextTick(world -> this.init(worlds));
    }

    public void init(List<ServerWorld> worlds) {
        for (World world : worlds) {
            ChunkManager chunkManager = ((ServerChunkProvider)world.func_72863_F()).field_217237_a;
            ChunkManager.ProxyTicketManager ticketManager = chunkManager.func_219246_e();
            this.total += chunkManager.func_219194_d();
            Iterable chunkHolders = chunkManager.func_223491_f();
            chunkHolders.forEach(arg_0 -> this.lambda$init$9((TicketManager)ticketManager, arg_0));
        }
    }

    public void reply(CommandSource source) {
        this.ticketsByLocation.forEach((name, locationticket) -> {
            source.func_197030_a((ITextComponent)new StringTextComponent(name + ": " + locationticket.count), true);
            locationticket.tickets.forEach((ticket, count) -> source.func_197030_a((ITextComponent)new StringTextComponent("    " + ticket + ": " + count), true));
        });
        source.func_197030_a((ITextComponent)new StringTextComponent("Non-Ticking chunks have little to no performance impact. See the GUI and minecraft wiki for what each type represents."), false);
    }

    public void replyWithLocation(CommandSource source, String word) throws CommandSyntaxException {
        source.func_197030_a((ITextComponent)new StringTextComponent("Chunks with LocationType " + word), true);
        Set<ChunkPos> chunkPos = this.chunksByLocationType.get(word);
        if (chunkPos != null) {
            this.sendChunkPositions(source, chunkPos);
        }
    }

    private void sendChunkPositions(CommandSource source, Set<ChunkPos> chunks) throws CommandSyntaxException {
        for (ChunkPos chunkPos : chunks) {
            BlockPos pos = chunkPos.func_206849_h();
            CommandUtils.sendCommandMessage(source, (IFormattableTextComponent)new StringTextComponent(chunkPos.toString()), "/cu tp " + (source.func_197022_f() instanceof PlayerEntity ? source.func_197035_h().func_200200_C_().getString() : "Console") + " " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p(), true);
        }
    }

    public void replyWithTicket(CommandSource source, String word) throws CommandSyntaxException {
        Set<ChunkPos> chunks = this.chunksByTicketName.get(word);
        if (chunks == null) {
            return;
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Chunks with " + word + " Ticket"), true);
        this.sendChunkPositions(source, chunks);
    }

    public void createReverseMapping() {
        this.chunksByTicketName.forEach((x, y) -> y.forEach(t -> this.ticketsByChunk.merge((ChunkPos)t, (Set<String>)new HashSet<String>(Collections.singleton(x)), (old, n) -> {
            old.add(x);
            return old;
        })));
        this.chunksByLocationType.forEach((x, y) -> y.forEach(t -> this.locationTypeByChunk.put((ChunkPos)t, (String)x)));
    }

    public String getTickets(ChunkPos pos) {
        Set<String> strings = this.ticketsByChunk.get(pos);
        if (strings == null || strings.isEmpty()) {
            return null;
        }
        if (strings.size() > 1) {
            strings.remove("unknown");
        }
        StringBuilder toReturn = new StringBuilder();
        Iterator<String> it = strings.iterator();
        while (it.hasNext()) {
            toReturn.append(it.next());
            if (!it.hasNext()) continue;
            toReturn.append(", ");
        }
        return toReturn.toString();
    }

    public String getLocationType(ChunkPos pos) {
        return this.locationTypeByChunk.get(pos);
    }

    public List<CUOption> getTicketsAsDropdownOptions(String filter) {
        return this.getCuDropDownOptions(filter, this.chunksByTicketName);
    }

    public List<CUOption> getStatesAsDropdownOptions(String filter) {
        return this.getCuDropDownOptions(filter, this.chunksByLocationType);
    }

    private List<CUOption> getCuDropDownOptions(String filter, Map<String, Set<ChunkPos>> chunkMap) {
        ArrayList<CUOption> list = new ArrayList<CUOption>();
        if (filter.isEmpty()) {
            chunkMap.forEach((string, set) -> list.add(new CUOption((String)string, set.size())));
        } else {
            chunkMap.get(filter).forEach(chunkPos -> list.add(new CUOption((ChunkPos)chunkPos)));
        }
        return list;
    }

    private /* synthetic */ void lambda$init$9(TicketManager ticketManager, ChunkHolder chunkHolder) {
        IChunk chunk = chunkHolder.func_219287_e();
        LocationTickets ticketCounter = null;
        if (chunk == null) {
            this.chunksByLocationType.merge("PRIMED", new HashSet<ChunkPos>(Collections.singletonList(chunkHolder.func_219277_h())), (list, newer) -> {
                list.add(chunkHolder.func_219277_h());
                return list;
            });
            this.ticketsByLocation.merge("PRIMED", new LocationTickets(), (x, y) -> {
                ++x.count;
                return x;
            });
            ticketCounter = this.ticketsByLocation.get("PRIMED");
        } else if (chunk instanceof Chunk) {
            Chunk actualChunk = (Chunk)chunk;
            this.chunksByLocationType.merge(actualChunk.func_217321_u().toString(), new HashSet<ChunkPos>(Collections.singletonList(chunkHolder.func_219277_h())), (list, newer) -> {
                list.add(chunkHolder.func_219277_h());
                return list;
            });
            this.ticketsByLocation.merge(actualChunk.func_217321_u().toString(), new LocationTickets(), (x, y) -> {
                ++x.count;
                return x;
            });
            ticketCounter = this.ticketsByLocation.get(actualChunk.func_217321_u().toString());
        } else if (chunk instanceof ChunkPrimer) {
            this.chunksByLocationType.merge(chunk.func_201589_g().func_222596_d().equals("full") ? "FULL" : "PARTIALLYGENERATED", new HashSet<ChunkPos>(Collections.singletonList(chunkHolder.func_219277_h())), (list, newer) -> {
                list.add(chunkHolder.func_219277_h());
                return list;
            });
            this.ticketsByLocation.merge(chunk.func_201589_g().func_222596_d().equals("full") ? "FULL" : "PARTIALLYGENERATED", new LocationTickets(), (x, y) -> {
                ++x.count;
                return x;
            });
            ticketCounter = this.ticketsByLocation.get(chunk.func_201589_g().func_222596_d().equals("full") ? "FULL" : "PARTIALLYGENERATED");
        }
        SortedArraySet tickets = ticketManager.func_229848_e_(chunkHolder.func_219277_h().func_201841_a());
        if (tickets.isEmpty()) {
            this.chunksByTicketName.merge("no_ticket", new HashSet<ChunkPos>(Collections.singletonList(chunkHolder.func_219277_h())), (old, nothing) -> {
                old.add(chunkHolder.func_219277_h());
                return old;
            });
        } else {
            for (Ticket ticket : tickets) {
                this.chunksByTicketName.merge(ticket.func_219479_a().toString(), new HashSet<ChunkPos>(Collections.singletonList(chunkHolder.func_219277_h())), (old, nothing) -> {
                    old.add(chunkHolder.func_219277_h());
                    return old;
                });
                if (ticketCounter == null) continue;
                ticketCounter.tickets.merge(ticket.func_219479_a().toString(), 1, Integer::sum);
            }
        }
    }

    private static class LocationTickets {
        int count;
        Map<String, Integer> tickets = new HashMap<String, Integer>();

        private LocationTickets() {
        }
    }
}

