/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands.PlayerCommands;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.WorldUtils;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TeleportCommand
implements Command<CommandSource> {
    private static final TeleportCommand cmd = new TeleportCommand();

    public static ArgumentBuilder<CommandSource, ?> register() {
        return Commands.func_197057_a((String)"tp").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)StringArgumentType.string()).suggests(CommandUtils.PROFILEPROVIDER).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes((Command)cmd)).then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).executes((Command)cmd)))).then(Commands.func_197056_a((String)"otherPlayer", (ArgumentType)StringArgumentType.string()).suggests(CommandUtils.PROFILEPROVIDER).executes((Command)cmd)));
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player;
        ServerWorld playerWorld = ((CommandSource)context.getSource()).func_197023_e();
        ServerWorld destWorld = null;
        String otherPlayerName = "";
        String playerName = "";
        BlockPos pos = null;
        try {
            destWorld = DimensionArgument.func_212592_a(context, (String)"dim");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            otherPlayerName = StringArgumentType.getString(context, (String)"otherPlayer");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            pos = BlockPosArgument.func_197274_b(context, (String)"pos");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (destWorld == null) {
            destWorld = playerWorld;
        }
        try {
            playerName = StringArgumentType.getString(context, (String)"player");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (playerName == null) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("player to teleport not specified"));
            return 0;
        }
        ServerPlayerEntity otherPlayer = ((CommandSource)context.getSource()).func_197028_i().func_184103_al().func_152612_a(otherPlayerName);
        if (pos == null && !otherPlayerName.isEmpty()) {
            if (otherPlayer != null) {
                pos = new BlockPos(otherPlayer.func_213303_ch());
            } else {
                AtomicReference offlinePlayerPos = new AtomicReference();
                if (!WorldUtils.applyToPlayer(otherPlayerName, ((CommandSource)context.getSource()).func_197028_i(), fakePlayer -> offlinePlayerPos.set(new BlockPos(fakePlayer.func_213303_ch())))) {
                    ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Unable to load target players data"));
                    return 0;
                }
                pos = (BlockPos)offlinePlayerPos.get();
            }
        }
        if ((player = ((CommandSource)context.getSource()).func_197028_i().func_184103_al().func_152612_a(playerName)) != null) {
            WorldUtils.teleportPlayer((PlayerEntity)player, (World)playerWorld, (World)destWorld, pos);
        } else {
            ServerWorld finalDestWorld = destWorld;
            BlockPos finalPos = pos;
            if (!WorldUtils.applyToPlayer(playerName, ((CommandSource)context.getSource()).func_197028_i(), fakePlayer -> {
                fakePlayer.func_70107_b((double)finalPos.func_177958_n(), (double)finalPos.func_177956_o(), (double)finalPos.func_177952_p());
                fakePlayer.func_70029_a((World)finalDestWorld);
            })) {
                ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Unable to read source player data"));
                return 0;
            }
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Teleported " + playerName + " to " + pos.toString()), true);
        return 1;
    }
}

