/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands.PlayerCommands;

import com.darkere.crashutils.DataStructures.PlayerActivityHistory;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class ActivityCommand {
    private static final SuggestionProvider<CommandSource> sugg = (ctx, builder) -> ISuggestionProvider.func_197005_b(Arrays.asList("week", "day", "month"), (SuggestionsBuilder)builder);

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"activity").executes(ActivityCommand::listActivity)).then(Commands.func_197056_a((String)"time", (ArgumentType)StringArgumentType.word()).suggests(sugg).executes(ctx -> ActivityCommand.listActivityByDate((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"time"))));
    }

    private static int listActivity(CommandContext<CommandSource> context) {
        PlayerActivityHistory history = new PlayerActivityHistory(((CommandSource)context.getSource()).func_197023_e());
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Number of Players active in the last:"), false);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Day: " + history.getDay().size() + " unique players"), false);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Week: " + history.getWeek().size() + " unique players"), false);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Month: " + history.getMonth().size() + " unique players"), false);
        return 1;
    }

    private static int listActivityByDate(CommandContext<CommandSource> context, String time) {
        PlayerActivityHistory history = new PlayerActivityHistory(((CommandSource)context.getSource()).func_197028_i().func_71218_a(World.field_234918_g_));
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Active Players in the last " + time), false);
        StringBuilder b = new StringBuilder();
        switch (time) {
            case "month": {
                history.getMonth().forEach(x -> {
                    b.append((String)x);
                    b.append(", ");
                });
                break;
            }
            case "week": {
                history.getWeek().forEach(x -> {
                    b.append((String)x);
                    b.append(", ");
                });
                break;
            }
            case "day": {
                history.getDay().forEach(x -> {
                    b.append((String)x);
                    b.append(", ");
                });
            }
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(b.toString()), false);
        return 1;
    }
}

