/*
 * Decompiled with CFR 0.152.
 */
package tfar.balancedenchanting;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.EnchantmentContainer;
import net.minecraftforge.fml.common.Mod;

@Mod(value="balancedenchanting")
public class BalancedEnchanting {
    public static final String MODID = "balancedenchanting";
    public static final ThreadLocal<Integer> id = ThreadLocal.withInitial(() -> 0);

    private static int getRequiredXpToNextLevel(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    public static int convertLevelToTotalxp(int level) {
        int sum = 0;
        for (int i = 0; i < level; ++i) {
            sum += BalancedEnchanting.getRequiredXpToNextLevel(i);
        }
        return sum;
    }

    public static void handleEnchantXp(PlayerEntity player, int cost) {
        Container menu = player.field_71070_bA;
        if (menu instanceof EnchantmentContainer) {
            EnchantmentContainer enchantmentContainer = (EnchantmentContainer)menu;
            int levelsRequired = enchantmentContainer.field_75167_g[id.get()];
            int level30Cost = BalancedEnchanting.convertLevelToTotalxp(levelsRequired);
            int level27Cost = BalancedEnchanting.convertLevelToTotalxp(levelsRequired + cost);
            player.func_195068_e(level27Cost - level30Cost);
        }
    }
}

