/*
 * Decompiled with CFR 0.152.
 */
package com.ma.tools.render;

import com.ma.api.blocks.tile.IMultiblockDefinition;
import com.ma.config.GeneralClientConfig;
import com.ma.tools.RotationUtils;
import com.ma.tools.math.MathUtils;
import com.ma.tools.render.GuiRenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.awt.Color;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.mutable.MutableInt;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class MultiblockRenderer {
    public static boolean hasMultiblock;
    private static IMultiblockDefinition multiblock;
    private static ITextComponent name;
    private static BlockPos renderPos;
    private static boolean posLocked;
    private static Rotation facingRotation;
    private static int blocks;
    private static int blocksDone;
    private static boolean syncWait;
    private static int timeComplete;
    private static BlockState lookingState;
    private static BlockPos lookingPos;
    private static IRenderTypeBuffer.Impl buffers;
    private static boolean lowestLayerMode;

    public static void setMultiblock(IMultiblockDefinition multiblock, ITextComponent name, boolean flip) {
        if (flip && hasMultiblock) {
            hasMultiblock = false;
        } else {
            MultiblockRenderer.multiblock = multiblock;
            MultiblockRenderer.name = name;
            renderPos = null;
            hasMultiblock = multiblock != null;
            posLocked = false;
        }
    }

    public static void toggleLowestLayerMode() {
        lowestLayerMode = !lowestLayerMode;
    }

    @SubscribeEvent
    public static void onRenderHUD(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && hasMultiblock) {
            int fullAnimTime;
            MatrixStack ms = event.getMatrixStack();
            Minecraft mc = Minecraft.func_71410_x();
            int waitTime = 40;
            int fadeOutSpeed = 4;
            float animTime = (float)timeComplete + (timeComplete == 0 ? 0.0f : event.getPartialTicks());
            if (animTime > (float)(fullAnimTime = waitTime + 10)) {
                hasMultiblock = false;
                return;
            }
            ms.func_227860_a_();
            ms.func_227861_a_(0.0, (double)(-Math.max(0.0f, animTime - (float)waitTime) * (float)fadeOutSpeed), 0.0);
            int x = event.getWindow().func_198107_o() / 2;
            int y = 16;
            int width = 180;
            int height = 9;
            int left = x - width / 2;
            int top = y + 10;
            if (timeComplete > 0) {
                String s = I18n.func_135052_a((String)"gui.mana-and-artifice:structure_complete", (Object[])new Object[0]);
                ms.func_227860_a_();
                ms.func_227861_a_(0.0, (double)Math.min((float)(height + 5), animTime), 0.0);
                mc.field_71466_p.func_238405_a_(ms, s, (float)(x - mc.field_71466_p.func_78256_a(s) / 2), (float)(top + height - 10), 65280);
                ms.func_227865_b_();
            }
            AbstractGui.func_238467_a_((MatrixStack)ms, (int)(left - 1), (int)(top - 1), (int)(left + width + 1), (int)(top + height + 1), (int)-16777216);
            GuiRenderUtils.drawGradientRect(ms, left, top, left + width, top + height, -10066330, -11184811);
            float pct = MathUtils.clamp01((float)blocksDone / (float)Math.max(1, blocks));
            int progressWidth = (int)((float)width * pct);
            int color = MathHelper.func_181758_c((float)(pct / 3.0f), (float)1.0f, (float)1.0f) | 0xFF000000;
            int color2 = new Color(color).darker().getRGB();
            GuiRenderUtils.drawGradientRect(ms, left, top, left + progressWidth, top + height, color, color2);
            if (mc.field_71474_y.field_211842_aO) {
                mc.field_71466_p.func_238407_a_(ms, name.func_241878_f(), (float)(x - mc.field_71466_p.func_238414_a_((ITextProperties)name) / 2), (float)(y + 10), 0xFFFFFF);
            } else {
                mc.field_71466_p.func_238407_a_(ms, name.func_241878_f(), (float)(x - mc.field_71466_p.func_238414_a_((ITextProperties)name) / 2), (float)(y + 11), 0xFFFFFF);
            }
            if (!posLocked) {
                String s = I18n.func_135052_a((String)"gui.mana-and-artifice:not_anchored", (Object[])new Object[0]);
                mc.field_71466_p.func_238405_a_(ms, s, (float)(x - mc.field_71466_p.func_78256_a(s) / 2), (float)(top + height + 8), 0xFFFFFF);
            } else {
                if (lookingState != null) {
                    try {
                        Block block = lookingState.func_177230_c();
                        ItemStack stack = block.getPickBlock(lookingState, mc.field_71476_x, (IBlockReader)mc.field_71441_e, lookingPos, (PlayerEntity)mc.field_71439_g);
                        if (!stack.func_190926_b()) {
                            mc.field_71466_p.func_238407_a_(ms, stack.func_200301_q().func_241878_f(), (float)(left + 20), (float)(top + height + 8), 0xFFFFFF);
                            GuiRenderUtils.renderItemStackInGui(ms, stack, left, top + height + 2);
                        }
                    }
                    catch (Exception block) {
                        // empty catch block
                    }
                }
                if (timeComplete == 0) {
                    color = 0xFFFFFF;
                    int posx = left + width;
                    int posy = top + height + 2;
                    int mult = 1;
                    String progress = blocksDone + "/" + blocks;
                    mc.field_71466_p.func_238405_a_(ms, progress, (float)(posx - mc.field_71466_p.func_78256_a(progress) / mult), (float)posy, color);
                }
            }
            ms.func_227865_b_();
        }
    }

    @SubscribeEvent
    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        if (hasMultiblock && multiblock != null) {
            MultiblockRenderer.renderMultiblock((World)Minecraft.func_71410_x().field_71441_e, event.getMatrixStack());
        }
    }

    public static void anchorTo(BlockPos target, Rotation rot) {
        renderPos = target;
        facingRotation = rot;
        posLocked = true;
        if (!((Boolean)GeneralClientConfig.MULTIBLOCK_TIP_SHOWN.get()).booleanValue()) {
            GeneralClientConfig.MULTIBLOCK_TIP_SHOWN.set((Object)true);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("helptip.mana-and-artifice.visualized_multiblock").func_240699_a_(TextFormatting.GOLD), Util.field_240973_b_);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (hasMultiblock && !posLocked && event.getPlayer() == Minecraft.func_71410_x().field_71439_g) {
            MultiblockRenderer.anchorTo(event.getPos().func_177972_a(event.getFace()), MultiblockRenderer.getRotation((Entity)event.getPlayer()));
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            hasMultiblock = false;
        } else if (posLocked && !syncWait && blocks == blocksDone) {
            if (++timeComplete == 16) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187604_bf, (float)1.0f));
            }
            if (timeComplete == 60) {
                MultiblockRenderer.setMultiblock(null, null, false);
            }
        } else {
            timeComplete = 0;
        }
    }

    public static void renderMultiblock(World world, MatrixStack ms) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!posLocked) {
            facingRotation = MultiblockRenderer.getRotation((Entity)mc.field_71439_g);
            if (mc.field_71476_x instanceof BlockRayTraceResult) {
                renderPos = ((BlockRayTraceResult)mc.field_71476_x).func_216350_a().func_177972_a(((BlockRayTraceResult)mc.field_71476_x).func_216354_b());
            }
        } else if (renderPos.func_218138_a((IPosition)mc.field_71439_g.func_213303_ch(), false) > 4096.0) {
            return;
        }
        if (renderPos == null) {
            return;
        }
        if (multiblock.isSymmetrical()) {
            facingRotation = Rotation.NONE;
        }
        EntityRendererManager erm = mc.func_175598_ae();
        double renderPosX = erm.field_217783_c.func_216785_c().func_82615_a();
        double renderPosY = erm.field_217783_c.func_216785_c().func_82617_b();
        double renderPosZ = erm.field_217783_c.func_216785_c().func_82616_c();
        ms.func_227861_a_(-renderPosX, -renderPosY, -renderPosZ);
        if (buffers == null) {
            buffers = MultiblockRenderer.initBuffers(mc.func_228019_au_().func_228487_b_());
        }
        BlockPos checkPos = null;
        if (mc.field_71476_x instanceof BlockRayTraceResult) {
            BlockRayTraceResult blockRes = (BlockRayTraceResult)mc.field_71476_x;
            checkPos = blockRes.func_216350_a().func_177972_a(blockRes.func_216354_b());
        }
        blocks = 0;
        blocksDone = 0;
        lookingState = null;
        lookingPos = checkPos;
        MutableInt lowestY = new MutableInt(Integer.MAX_VALUE);
        HashMap<BlockPos, BlockState> missingBlocks = multiblock.getMissingBlocks(world, MultiblockRenderer.getStartPos(), MultiblockRenderer.getFacingRotation(), true);
        if (missingBlocks != null) {
            blocksDone = multiblock.getBlockCount() - missingBlocks.size();
            blocks = multiblock.getBlockCount();
            float alpha = 0.3f;
            if (lowestLayerMode) {
                missingBlocks.entrySet().stream().forEach(e -> {
                    if (lowestY.getValue() > ((BlockPos)e.getKey()).func_177956_o()) {
                        lowestY.setValue(((BlockPos)e.getKey()).func_177956_o());
                    }
                });
            }
            missingBlocks.entrySet().forEach(e -> {
                if (!MultiblockRenderer.posLocked() || !lowestLayerMode || ((BlockPos)e.getKey()).func_177956_o() == lowestY.getValue().intValue()) {
                    MultiblockRenderer.renderBlock(world, (BlockState)e.getValue(), (BlockPos)e.getKey(), alpha, ms);
                }
            });
            syncWait = false;
        } else {
            syncWait = true;
        }
        buffers.func_228461_a_();
        if (!posLocked) {
            blocksDone = 0;
            blocks = 0;
        }
    }

    public static void renderBlock(World world, BlockState state, BlockPos pos, float alpha, MatrixStack ms) {
        if (pos != null) {
            ms.func_227860_a_();
            ms.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            if (state.func_177230_c() == Blocks.field_150350_a) {
                float scale = 0.3f;
                float off = (1.0f - scale) / 2.0f;
                ms.func_227861_a_((double)off, (double)off, (double)(-off));
                ms.func_227862_a_(scale, scale, scale);
                state = Blocks.field_196856_iQ.func_176223_P();
            }
            Minecraft.func_71410_x().func_175602_ab().func_228791_a_(state, ms, (IRenderTypeBuffer)buffers, 0xF000F0, OverlayTexture.field_229196_a_);
            ms.func_227865_b_();
        }
    }

    public static IMultiblockDefinition getMultiblock() {
        return multiblock;
    }

    public static boolean posLocked() {
        return posLocked;
    }

    public static Rotation getFacingRotation() {
        return multiblock.isSymmetrical() ? Rotation.NONE : facingRotation;
    }

    public static BlockPos getStartPos() {
        return renderPos;
    }

    private static Rotation getRotation(Entity entity) {
        return RotationUtils.rotationFromFacing(entity.func_174811_aO());
    }

    private static IRenderTypeBuffer.Impl initBuffers(IRenderTypeBuffer.Impl original) {
        BufferBuilder fallback = (BufferBuilder)ObfuscationReflectionHelper.getPrivateValue(IRenderTypeBuffer.Impl.class, (Object)original, (String)"field_228457_a_");
        Map layerBuffers = (Map)ObfuscationReflectionHelper.getPrivateValue(IRenderTypeBuffer.Impl.class, (Object)original, (String)"field_228458_b_");
        Object2ObjectLinkedOpenHashMap remapped = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry e : layerBuffers.entrySet()) {
            remapped.put(GhostRenderType.remap((RenderType)e.getKey()), e.getValue());
        }
        return new GhostBuffers(fallback, (Map<RenderType, BufferBuilder>)remapped);
    }

    static {
        syncWait = true;
        buffers = null;
        lowestLayerMode = true;
    }

    private static class GhostRenderType
    extends RenderType {
        private static Map<RenderType, RenderType> remappedTypes = new IdentityHashMap<RenderType, RenderType>();

        private GhostRenderType(RenderType original) {
            super(String.format("%s_%s_ghost", original.toString(), "mana-and-artifice"), original.func_228663_p_(), original.func_228664_q_(), original.func_228662_o_(), original.func_228665_s_(), true, () -> {
                original.func_228547_a_();
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.CONSTANT_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_CONSTANT_ALPHA);
                RenderSystem.blendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            }, () -> {
                RenderSystem.blendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableBlend();
                RenderSystem.enableDepthTest();
                original.func_228549_b_();
            });
        }

        public boolean equals(@Nullable Object other) {
            return this == other;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public static RenderType remap(RenderType in) {
            if (in instanceof GhostRenderType) {
                return in;
            }
            return remappedTypes.computeIfAbsent(in, GhostRenderType::new);
        }
    }

    private static class GhostBuffers
    extends IRenderTypeBuffer.Impl {
        protected GhostBuffers(BufferBuilder fallback, Map<RenderType, BufferBuilder> layerBuffers) {
            super(fallback, layerBuffers);
        }

        public IVertexBuilder getBuffer(RenderType type) {
            return super.getBuffer(GhostRenderType.remap(type));
        }
    }
}

