/*
 * Decompiled with CFR 0.152.
 */
package com.ma.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class NBTUtilities {
    public static CompoundNBT fromJSON(JsonObject object) {
        CompoundNBT output = new CompoundNBT();
        for (Map.Entry elem : object.entrySet()) {
            if (((JsonElement)elem.getValue()).isJsonPrimitive()) {
                JsonPrimitive primitive = ((JsonElement)elem.getValue()).getAsJsonPrimitive();
                if (primitive.isBoolean()) {
                    output.func_74757_a((String)elem.getKey(), primitive.getAsBoolean());
                    continue;
                }
                if (primitive.isNumber()) {
                    Number val = primitive.getAsNumber();
                    if (val.floatValue() % 1.0f == 0.0f) {
                        output.func_74768_a((String)elem.getKey(), val.intValue());
                        continue;
                    }
                    output.func_74776_a((String)elem.getKey(), val.floatValue());
                    continue;
                }
                if (!primitive.isString()) continue;
                output.func_74778_a((String)elem.getKey(), primitive.getAsString());
                continue;
            }
            if (!((JsonElement)elem.getValue()).isJsonObject()) continue;
            output.func_218657_a((String)elem.getKey(), (INBT)NBTUtilities.fromJSON(((JsonElement)elem.getValue()).getAsJsonObject()));
        }
        return output;
    }
}

