/*
 * Decompiled with CFR 0.152.
 */
package com.ma.tools;

import com.ma.inventory.InventoryRitualKit;
import com.ma.inventory.ItemInventoryBase;
import com.ma.items.ItemInit;
import com.ma.items.ritual.ItemPractitionersPouch;
import com.ma.items.ritual.PractitionersPouchPatches;
import com.ma.items.runes.ItemRuneMarking;
import com.ma.tools.MATags;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;

public class InventoryUtilities {
    public static boolean mergeIntoInventory(IItemHandler handler, ItemStack toMerge) {
        return InventoryUtilities.mergeIntoInventory(handler, toMerge, toMerge.func_190916_E());
    }

    public static boolean mergeIntoInventory(IItemHandler handler, ItemStack toMerge, int quantity) {
        if (quantity > toMerge.func_190916_E()) {
            quantity = toMerge.func_190916_E();
        }
        int emptySlot = -1;
        ItemStack insertStack = toMerge.func_77946_l();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!handler.isItemValid(i, insertStack)) continue;
            ItemStack inventoryStack = handler.getStackInSlot(i);
            if (inventoryStack.func_190926_b()) {
                if (emptySlot != -1) continue;
                emptySlot = i;
                continue;
            }
            if (!inventoryStack.func_77969_a(insertStack) || inventoryStack.func_190916_E() >= handler.getSlotLimit(i)) continue;
            int spaceAvailable = handler.getSlotLimit(i) - inventoryStack.func_190916_E();
            ItemStack split = insertStack.func_77979_a(Math.min(quantity, spaceAvailable));
            ItemStack remainder = handler.insertItem(i, split, false);
            int amountInserted = split.func_190916_E() - remainder.func_190916_E();
            toMerge.func_190920_e(toMerge.func_190916_E() - amountInserted);
            if ((quantity -= amountInserted) <= 0) {
                return true;
            }
            if (remainder.func_190916_E() <= 0) continue;
            insertStack = remainder;
        }
        if (quantity > 0 && emptySlot > -1) {
            ItemStack insert = ItemStack.field_190927_a;
            int maxStackSize = handler.getSlotLimit(emptySlot);
            if (insertStack.func_190916_E() > maxStackSize) {
                insert = insertStack.func_77979_a(maxStackSize);
                insert = handler.insertItem(emptySlot, insert, false);
                insertStack.func_190920_e(insertStack.func_190916_E() + insert.func_190916_E());
            } else {
                insertStack = handler.insertItem(emptySlot, insertStack, false);
            }
            toMerge.func_190920_e(insertStack.func_190916_E());
            return toMerge.func_190916_E() == 0;
        }
        return false;
    }

    public static ItemStack getFirstItemFromContainer(List<Item> items, int maxCount, IItemHandler handler, Direction side) {
        return InventoryUtilities.getFirstItemFromContainer(items, maxCount, handler, side, false);
    }

    public static ItemStack getFirstItemFromContainer(List<Item> items, int maxCount, IItemHandler handler, Direction side, boolean simulate) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b() || items.size() != 0 && !items.contains(stack.func_77973_b())) continue;
            int count = Math.min(stack.func_190916_E(), maxCount);
            return handler.extractItem(i, count, simulate);
        }
        return ItemStack.field_190927_a;
    }

    public static boolean hasStackInInventory(ItemStack search, boolean ignoreDurability, boolean compareNBT, IItemHandlerModifiable inventory) {
        int countToFind = search.func_190916_E();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            boolean equal;
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            boolean bl = equal = ignoreDurability ? ItemStack.func_185132_d((ItemStack)stack, (ItemStack)search) : ItemStack.func_179545_c((ItemStack)stack, (ItemStack)search);
            if (compareNBT) {
                equal &= ItemStack.func_77970_a((ItemStack)stack, (ItemStack)search);
            }
            if (!equal || (countToFind -= stack.func_190916_E()) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean removeItemFromInventory(ItemStack search, boolean ignoreDurability, boolean compareNBT, IItemHandlerModifiable inventory) {
        int countToRemove = search.func_190916_E();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            boolean equal;
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            boolean bl = equal = ignoreDurability ? ItemStack.func_185132_d((ItemStack)stack, (ItemStack)search) : ItemStack.func_179545_c((ItemStack)stack, (ItemStack)search);
            if (compareNBT) {
                equal &= ItemStack.func_77970_a((ItemStack)stack, (ItemStack)search);
            }
            if (!equal) continue;
            int removeQty = Math.min(countToRemove, stack.func_190916_E());
            stack.func_190918_g(removeQty);
            if ((countToRemove -= removeQty) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasStackInInventory(ItemStack search, boolean ignoreDurability, boolean compareNBT, IItemHandler inventory, Direction face) {
        int countToFind = search.func_190916_E();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            boolean equal;
            ItemStack stack = inventory.extractItem(i, countToFind, true);
            if (stack.func_190926_b()) continue;
            boolean bl = equal = ignoreDurability ? ItemStack.func_185132_d((ItemStack)stack, (ItemStack)search) : ItemStack.func_179545_c((ItemStack)stack, (ItemStack)search);
            if (compareNBT) {
                equal &= ItemStack.func_77970_a((ItemStack)stack, (ItemStack)search);
            }
            if (!equal || (countToFind -= stack.func_190916_E()) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean removeItemFromInventory(ItemStack search, boolean ignoreDurability, boolean compareNBT, IItemHandler inventory, Direction face) {
        int countToRemove = search.func_190916_E();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack extracted;
            boolean equal;
            ItemStack stack = inventory.extractItem(i, countToRemove, true);
            if (stack.func_190926_b()) continue;
            boolean bl = equal = ignoreDurability ? ItemStack.func_185132_d((ItemStack)stack, (ItemStack)search) : ItemStack.func_179545_c((ItemStack)stack, (ItemStack)search);
            if (compareNBT) {
                equal &= ItemStack.func_77970_a((ItemStack)stack, (ItemStack)search);
            }
            if (!equal || (extracted = inventory.extractItem(i, countToRemove, false)).func_190926_b() || (countToRemove -= extracted.func_190916_E()) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean consumeAcrossInventories(ItemStack search, boolean ignoreDurability, boolean compareNBT, boolean simulate, List<Pair<IItemHandler, Direction>> inventories) {
        int count = search.func_190916_E();
        for (int idx = 0; idx < inventories.size(); ++idx) {
            IItemHandler inventory = (IItemHandler)inventories.get(idx).getFirst();
            Direction face = (Direction)inventories.get(idx).getSecond();
            boolean invConsumed = false;
            for (int i = 0; i < inventory.getSlots(); ++i) {
                boolean equal;
                ItemStack stack = inventory.extractItem(i, count, true);
                if (stack.func_190926_b()) continue;
                boolean bl = equal = ignoreDurability ? ItemStack.func_185132_d((ItemStack)stack, (ItemStack)search) : ItemStack.func_179545_c((ItemStack)stack, (ItemStack)search);
                if (compareNBT) {
                    equal &= ItemStack.func_77970_a((ItemStack)stack, (ItemStack)search);
                }
                if (!equal) continue;
                if (!simulate) {
                    ItemStack extracted = inventory.extractItem(i, count, false);
                    if (!extracted.func_190926_b()) {
                        count -= extracted.func_190916_E();
                        invConsumed = true;
                    }
                } else {
                    count -= stack.func_190916_E();
                    invConsumed = true;
                }
                if (count > 0) continue;
                if (inventory instanceof ItemInventoryBase) {
                    ((ItemInventoryBase)inventory).writeItemStack();
                }
                return true;
            }
            if (!invConsumed || !(inventory instanceof ItemInventoryBase)) continue;
            ((ItemInventoryBase)inventory).writeItemStack();
        }
        return false;
    }

    public static int countItem(Item item, IItemHandler inventory, Direction face) {
        int i = 0;
        for (int j = 0; j < inventory.getSlots(); ++j) {
            ItemStack itemstack = inventory.getStackInSlot(j);
            if (!itemstack.func_77973_b().equals(item)) continue;
            i += itemstack.func_190916_E();
        }
        return i;
    }

    public static ItemStack removeSingleItemFromInventory(ResourceLocation search, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || !MATags.isItemEqual(stack, search)) continue;
            return stack.func_77979_a(1);
        }
        return ItemStack.field_190927_a;
    }

    public static void redirectCaptureOrDrop(PlayerEntity player, World world, List<ItemStack> drops, boolean allowRedirect) {
        if (allowRedirect) {
            ItemStack mainHand = player.func_184614_ca();
            ItemStack offHand = player.func_184592_cb();
            BlockPos redirLoc = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(mainHand.func_77973_b() == ItemInit.RUNE_MARKING.get() ? mainHand : offHand);
            if (redirLoc != null) {
                LazyOptional handler;
                TileEntity te;
                Direction redirFace = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getFace(mainHand.func_77973_b() == ItemInit.RUNE_MARKING.get() ? mainHand : offHand);
                if (world.func_195588_v(redirLoc) && (te = world.func_175625_s(redirLoc)) != null && (handler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, redirFace)).isPresent()) {
                    for (int i = 0; i < drops.size(); ++i) {
                        if (!InventoryUtilities.mergeIntoInventory((IItemHandler)handler.resolve().get(), drops.get(i))) continue;
                        drops.remove(i);
                        --i;
                    }
                }
            }
        }
        ArrayList<InventoryRitualKit> playerKits = new ArrayList<InventoryRitualKit>();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ItemPractitionersPouch) || ((ItemPractitionersPouch)stack.func_77973_b()).getPatchLevel(stack, PractitionersPouchPatches.COLLECTION) <= 0) continue;
            playerKits.add(new InventoryRitualKit(stack));
        }
        for (ItemStack stack : drops) {
            InventoryRitualKit kit;
            Iterator iterator = playerKits.iterator();
            while (iterator.hasNext() && !(stack = (kit = (InventoryRitualKit)iterator.next()).addItem(stack)).func_190926_b()) {
            }
            if (stack.func_190926_b() || player.func_191521_c(stack)) continue;
            player.func_199701_a_(stack);
        }
        for (InventoryRitualKit kit : playerKits) {
            kit.writeItemStack();
        }
    }

    public static Pair<Boolean, Boolean> getCaptureAndRedirect(PlayerEntity player) {
        boolean captureDrops = false;
        boolean redirectDrops = false;
        if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.COLLECTOR_RING_GREATER.get(), (LivingEntity)player).isPresent()) {
            captureDrops = true;
            redirectDrops = true;
        } else if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.COLLECTOR_RING_LESSER.get(), (LivingEntity)player).isPresent()) {
            captureDrops = true;
        }
        return new Pair((Object)captureDrops, (Object)redirectDrops);
    }
}

