/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.shapes;

import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.parts.Shape;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.config.GeneralModConfig;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedSpellEffect;
import com.ma.items.sorcery.ItemCrystalPhylactery;
import com.ma.spells.shapes.ShapeRaytrace;
import com.ma.tools.SummonUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ShapeSummon
extends ShapeRaytrace {
    public ShapeSummon(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.DURATION, 30.0f, 30.0f, 240.0f, 30.0f, 20.0f), new AttributeValuePair(Attribute.RANGE, 8.0f, 1.0f, 32.0f, 1.0f, 2.0f), new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 3.0f, 1.0f, 10.0f));
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public List<SpellTarget> Target(SpellSource source, World world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition recipe) {
        List<SpellTarget> supertargets;
        SpellTarget supertarget;
        if (source.isPlayerCaster() && (supertarget = (supertargets = super.Target(source, world, modificationData, recipe)).get(0)) != SpellTarget.NONE) {
            if (!world.field_72995_K) {
                ItemStack phylactery;
                ItemStack itemStack = phylactery = source.getHand() == Hand.MAIN_HAND ? source.getPlayer().func_184592_cb() : source.getPlayer().func_184614_ca();
                if (!ItemCrystalPhylactery.isFilled(phylactery)) {
                    source.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:shapes/summon.nophylactery"), Util.field_240973_b_);
                    return Arrays.asList(SpellTarget.NONE);
                }
                EntityType<? extends MobEntity> type = ItemCrystalPhylactery.getEntityType(phylactery);
                if (type == null) {
                    source.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:shapes/summon.nophylactery"), Util.field_240973_b_);
                    return Arrays.asList(SpellTarget.NONE);
                }
                SummonUtils.clampSummons(source.getPlayer());
                String name = source.getPlayer().func_145748_c_().getString();
                StringTextComponent summonName = new StringTextComponent(name);
                summonName.func_240702_b_("'s ");
                summonName.func_230529_a_((ITextComponent)new TranslationTextComponent(type.func_210760_d()));
                MobEntity summon = (MobEntity)type.func_220349_b((ServerWorld)world, new CompoundNBT(), (ITextComponent)summonName, source.getPlayer(), supertarget.getBlock().func_177984_a(), SpawnReason.MOB_SUMMONED, false, false);
                if (!((Boolean)GeneralModConfig.MA_SUMMON_BOSSES.get()).booleanValue() && !summon.func_184222_aU()) {
                    return Arrays.asList(SpellTarget.NONE);
                }
                int magnitude = (int)modificationData.getValue(Attribute.MAGNITUDE);
                if (!this.magnitudeHealthCheck(source, new SpellTarget((Entity)summon), magnitude, 20)) {
                    return Arrays.asList(SpellTarget.NONE);
                }
                SummonUtils.setSummon(summon, source.getPlayer(), (int)(modificationData.getValue(Attribute.DURATION) * 20.0f));
                SpellTarget tgt = new SpellTarget((Entity)summon);
                SpellContext context = new SpellContext((ServerWorld)world, recipe, (Entity)summon);
                recipe.getComponents().forEach(c -> {
                    int delay = (int)Math.max(10.0f, c.getValue(Attribute.DELAY) * 20.0f);
                    DelayedEventQueue.pushEvent((World)context.getWorld(), new TimedDelayedSpellEffect("summon_delay", delay, source, tgt, (IModifiedSpellPart<Component>)c, context));
                });
                if (!world.func_217376_c((Entity)summon)) {
                    return Arrays.asList(SpellTarget.NONE);
                }
                SummonUtils.addTrackedSummon(source.getPlayer(), summon);
            }
            return Arrays.asList(new SpellTarget((Entity)source.getPlayer()));
        }
        return Arrays.asList(SpellTarget.NONE);
    }

    @Override
    public boolean spawnsTargetEntity() {
        return true;
    }

    @Override
    public float initialComplexity() {
        return 40.0f;
    }

    @Override
    public int baselineCooldown() {
        return 20;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.FRIENDLY;
    }
}

