/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.crafting;

import com.google.common.collect.ImmutableList;
import com.ma.ManaAndArtifice;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiable;
import com.ma.api.spells.base.IModifiedSpellPart;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ModifiedSpellPart<T extends IForgeRegistryEntry<T> & IModifiable>
implements IModifiedSpellPart<T> {
    private final T part;
    private ImmutableList<AttributeValuePair> attributeValues;

    public ModifiedSpellPart(T part) {
        this.part = part;
        this.attributeValues = ImmutableList.copyOf(((IModifiable)part).getModifiableAttributes());
    }

    @Override
    public final T getPart() {
        return this.part;
    }

    @Override
    public final float getMaximumValue(Attribute attribute) {
        for (AttributeValuePair pair : this.attributeValues) {
            if (pair.getAttribute() != attribute) continue;
            return pair.getMaximum();
        }
        return 0.0f;
    }

    @Override
    public final float getMinimumValue(Attribute attribute) {
        for (AttributeValuePair pair : this.attributeValues) {
            if (pair.getAttribute() != attribute) continue;
            return pair.getMinimum();
        }
        return 0.0f;
    }

    @Override
    public final float getValue(Attribute attribute) {
        for (AttributeValuePair pair : this.attributeValues) {
            if (pair.getAttribute() != attribute) continue;
            return pair.getValue();
        }
        return 0.0f;
    }

    @Override
    public final float getMultiplier(Attribute attribute) {
        for (AttributeValuePair pair : this.attributeValues) {
            if (pair.getAttribute() != attribute) continue;
            return pair.getMultiplier();
        }
        return 1.0f;
    }

    @Override
    public final boolean setValue(Attribute attribute, float value) {
        for (AttributeValuePair pair : this.attributeValues) {
            if (pair.getAttribute() != attribute || pair.getValue() == value) continue;
            pair.setValue(value);
            return true;
        }
        return false;
    }

    @Override
    public final boolean setMultiplier(Attribute attribute, float value) {
        for (AttributeValuePair pair : this.attributeValues) {
            if (pair.getAttribute() != attribute || pair.getValue() == value) continue;
            pair.setMultiplier(value);
            return true;
        }
        return false;
    }

    @Override
    public final boolean resetMultiplier(Attribute attribute) {
        for (AttributeValuePair pair : this.attributeValues) {
            if (pair.getAttribute() != attribute) continue;
            pair.setMultiplier(1.0f);
            return true;
        }
        return false;
    }

    @Override
    public final float getDefaultValue(Attribute attribute) {
        for (AttributeValuePair pair : this.attributeValues) {
            if (pair.getAttribute() != attribute) continue;
            return pair.getDefaultValue();
        }
        return 0.0f;
    }

    @Override
    public final float getStep(Attribute attribute) {
        for (AttributeValuePair pair : this.attributeValues) {
            if (pair.getAttribute() != attribute) continue;
            return pair.getStep();
        }
        return 1.0f;
    }

    @Override
    public final float getStepComplexity(Attribute attribute) {
        for (AttributeValuePair pair : this.attributeValues) {
            if (pair.getAttribute() != attribute) continue;
            return pair.getStepComplexity();
        }
        return 1.0f;
    }

    @Override
    public final void resetValueToDefault(Attribute attribute) {
        for (AttributeValuePair pair : this.attributeValues) {
            if (pair.getAttribute() != attribute) continue;
            pair.setValue(pair.getDefaultValue());
        }
    }

    @Override
    public final float stepUp(Attribute attribute) {
        for (AttributeValuePair pair : this.attributeValues) {
            if (pair.getAttribute() != attribute) continue;
            return pair.stepUp();
        }
        return 0.0f;
    }

    @Override
    public final float stepDown(Attribute attribute) {
        for (AttributeValuePair pair : this.attributeValues) {
            if (pair.getAttribute() != attribute) continue;
            return pair.stepDown();
        }
        return 0.0f;
    }

    @Override
    public final ImmutableList<Attribute> getContainedAttributes() {
        Attribute[] attrs = new Attribute[this.attributeValues.size()];
        for (int i = 0; i < this.attributeValues.size(); ++i) {
            attrs[i] = ((AttributeValuePair)this.attributeValues.get(i)).getAttribute();
        }
        return ImmutableList.copyOf((Object[])attrs);
    }

    public CompoundNBT toNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.part != null) {
            nbt.func_74778_a("resource_location", this.part.getRegistryName().toString());
            nbt.func_74768_a("num_attributes", this.getContainedAttributes().size());
            int count = 0;
            for (Attribute attr : this.getContainedAttributes()) {
                float value = this.getValue(attr);
                nbt.func_74778_a("attribute_" + count, attr.name());
                nbt.func_74776_a("value_" + count, value);
                ++count;
            }
        } else {
            nbt.func_74778_a("resource_location", ManaAndArtifice.EMPTY.toString());
            nbt.func_74768_a("num_attributes", 0);
        }
        return nbt;
    }

    public static <T extends IForgeRegistryEntry<T> & IModifiable> ModifiedSpellPart<T> fromNBT(CompoundNBT nbt, IForgeRegistry<T> registry) {
        if (!nbt.func_74764_b("resource_location")) {
            return null;
        }
        ResourceLocation rLoc = new ResourceLocation(nbt.func_74779_i("resource_location"));
        if (!registry.containsKey(rLoc)) {
            return null;
        }
        IForgeRegistryEntry inst = registry.getValue(rLoc);
        ModifiedSpellPart<IForgeRegistryEntry> msp = new ModifiedSpellPart<IForgeRegistryEntry>(inst);
        if (!nbt.func_74764_b("num_attributes")) {
            return msp;
        }
        int attributes = nbt.func_74762_e("num_attributes");
        for (int i = 0; i < attributes; ++i) {
            if (!nbt.func_74764_b("attribute_" + i) || !nbt.func_74764_b("value_" + i)) continue;
            try {
                Attribute attr = Attribute.valueOf(nbt.func_74779_i("attribute_" + i));
                float value = nbt.func_74760_g("value_" + i);
                msp.setValue(attr, value);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return msp;
    }
}

