/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.Faction;
import com.ma.api.sound.SFX;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.entities.EntityInit;
import com.ma.entities.summon.EntitySummonedSpectralHorse;
import com.ma.tools.SummonUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class ComponentSummonSkeletalHorse
extends Component {
    public ComponentSummonSkeletalHorse(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.DURATION, 120.0f, 30.0f, 1200.0f, 30.0f, 1.75f));
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (source.isPlayerCaster()) {
            int offsetCount;
            if (context.hasEntityBeenAffected(this, (Entity)source.getCaster())) {
                return ComponentApplicationResult.FAIL;
            }
            context.addAffectedEntity(this, (Entity)source.getCaster());
            for (offsetCount = 0; !context.getWorld().func_175623_d(target.getBlock().func_177981_b(offsetCount)) && offsetCount < 5; ++offsetCount) {
            }
            if (offsetCount >= 5) {
                return ComponentApplicationResult.FAIL;
            }
            EntitySummonedSpectralHorse horse = (EntitySummonedSpectralHorse)((EntityType)EntityInit.SPECTRAL_HORSE.get()).func_200721_a((World)context.getWorld());
            DifficultyInstance difficultyinstance = context.getWorld().func_175649_E(target.getBlock());
            horse.func_213386_a((IServerWorld)context.getWorld(), difficultyinstance, SpawnReason.TRIGGERED, null, null);
            horse.func_70107_b(target.getPosition().field_72450_a, target.getPosition().field_72448_b + (double)offsetCount, target.getPosition().field_72449_c);
            horse.field_70172_ad = 60;
            horse.func_110163_bv();
            horse.func_110263_g(source.getPlayer());
            horse.func_70873_a(0);
            horse.func_230266_a_(null);
            SummonUtils.clampSummons(source.getPlayer());
            SummonUtils.setSummon((MobEntity)horse, source.getPlayer(), false, (int)(modificationData.getValue(Attribute.DURATION) * 20.0f));
            context.getWorld().func_217376_c((Entity)horse);
            SummonUtils.addTrackedSummon(source.getPlayer(), (MobEntity)horse);
            if (context.getSpawnedTargetEntity() != null && context.getSpawnedTargetEntity() instanceof LivingEntity) {
                ((LivingEntity)context.getSpawnedTargetEntity()).func_184205_a((Entity)horse, true);
            } else if (target.isLivingEntity() && target.getLivingEntity() == source.getCaster()) {
                source.getCaster().func_184205_a((Entity)horse, true);
            }
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public Faction getFactionRequirement() {
        return Faction.UNDEAD;
    }

    @Override
    public boolean canBeChanneled() {
        return false;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ICE;
    }

    @Override
    public float initialComplexity() {
        return 20.0f;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Entity.SpectralHorse.SUMMON;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.FRIENDLY;
    }
}

