/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.WellspringNode;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.config.GeneralModConfig;
import com.ma.effects.EffectInit;
import com.ma.entities.utility.EntityEldrinFlight;
import com.ma.network.ServerMessageDispatcher;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableObject;

public class ComponentEldrinFlight
extends Component {
    public ComponentEldrinFlight(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair[0]);
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (source.isPlayerCaster() && target.isEntity() && target.getEntity() instanceof PlayerEntity) {
            if (source.getPlayer() != target.getEntity() && !source.getPlayer().func_184191_r(target.getEntity())) {
                return ComponentApplicationResult.FAIL;
            }
            int dist = (Integer)GeneralModConfig.MA_NODE_DISTANCE.get();
            if (!source.getPlayer().func_70644_a((Effect)EffectInit.CHOOSING_WELLSPRING.get())) {
                source.getPlayer().func_195064_c(new EffectInstance((Effect)EffectInit.CHOOSING_WELLSPRING.get(), 200));
                ServerMessageDispatcher.sendWellspringSyncMessage(context.getWorld(), (ServerPlayerEntity)source.getPlayer(), (int)((double)dist * 1.5));
                return ComponentApplicationResult.FAIL;
            }
            source.getPlayer().func_195063_d((Effect)EffectInit.CHOOSING_WELLSPRING.get());
            Vector3d start = new Vector3d(source.getOrigin().func_82615_a(), 0.0, source.getOrigin().func_82616_c());
            MutableBoolean success = new MutableBoolean(false);
            context.getWorld().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
                int halfDist = dist / 2;
                HashMap<BlockPos, WellspringNode> nodes = m.getWellspringRegistry().getNearbyNodes(source.getPlayer().func_233580_cy_(), 50, dist + halfDist);
                if (nodes.size() == 0) {
                    source.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:components/eldrin_flight.none-nearby"), Util.field_240973_b_);
                } else {
                    MutableObject selectedWellspring = new MutableObject();
                    MutableFloat closestAngle = new MutableFloat((Number)Math.PI);
                    Vector3d playerLook = Vector3d.func_189984_a((Vector2f)new Vector2f(0.0f, source.getPlayer().field_70759_as));
                    double startLength = playerLook.func_72433_c();
                    nodes.forEach((pos, node) -> {
                        double aLenTimesBLen;
                        Vector3d nodePos = new Vector3d((double)pos.func_177958_n() + 0.5, node.hasForcedYLevel() ? (double)(node.getYLevel() - 3) : -1.0, (double)pos.func_177952_p() + 0.5);
                        Vector3d nodeDir = nodePos.func_178788_d(start);
                        double dot = playerLook.func_72430_b(nodeDir);
                        double theta = Math.acos(dot / (aLenTimesBLen = startLength * nodeDir.func_72433_c()));
                        if (theta < (double)closestAngle.getValue().floatValue()) {
                            closestAngle.setValue((Number)theta);
                            selectedWellspring.setValue((Object)nodePos);
                        }
                    });
                    target.getLivingEntity().func_195064_c(new EffectInstance((Effect)EffectInit.ELDRIN_FLIGHT.get(), 600));
                    Vector3d end = (Vector3d)selectedWellspring.getValue();
                    EntityEldrinFlight travel = new EntityEldrinFlight((World)context.getWorld(), (PlayerEntity)target.getEntity(), target.getEntity().func_213303_ch(), end);
                    context.getWorld().func_217376_c((Entity)travel);
                    target.getLivingEntity().getPersistentData().func_74768_a("eldrin_flight_entity_id", travel.func_145782_y());
                    success.setTrue();
                }
            });
            if (success.getValue().booleanValue()) {
                return ComponentApplicationResult.SUCCESS;
            }
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ARCANE;
    }

    @Override
    public Faction getFactionRequirement() {
        return Faction.ANCIENT_WIZARDS;
    }

    @Override
    public float initialComplexity() {
        return 55.0f;
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.FRIENDLY;
    }
}

