/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells;

import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.spells.adjusters.SpellAdjustingContext;
import com.ma.api.spells.adjusters.SpellCastStage;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.effects.EffectInit;
import com.ma.interop.CuriosInterop;
import com.ma.items.IHellfireItem;
import com.ma.items.ItemInit;
import com.ma.items.artifice.curio.ItemEldrinBracelet;
import com.ma.items.sorcery.ItemSpell;
import com.ma.spells.SpellsInit;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;

public final class SpellAdjusters {
    private static final float AFFINITY_MANA_COST_FACTOR = 0.5f;

    public static final void modifyBasedOnAffinity(ISpellDefinition recipe, @Nullable PlayerEntity caster) {
        if (caster == null) {
            return;
        }
        LazyOptional magicContainer = caster.getCapability(PlayerMagicProvider.MAGIC);
        if (!magicContainer.isPresent()) {
            return;
        }
        IPlayerMagic magic = (IPlayerMagic)magicContainer.orElse(null);
        if (magic == null) {
            return;
        }
        float base_mana_cost = recipe.getManaCost();
        float modification_reduce = 0.0f;
        float modification_increase = 0.0f;
        HashMap<Affinity, Float> affList = recipe.getAffinity();
        for (Affinity affinity : affList.keySet()) {
            Affinity mainAdjuster = affinity.getShiftAffinity();
            Affinity oppositeAdjuster = affinity.getOpposite().getShiftAffinity();
            modification_reduce += magic.getAffinityDepth(mainAdjuster) * 0.5f / 100.0f * affList.get((Object)affinity).floatValue();
            modification_increase += magic.getAffinityDepth(oppositeAdjuster) * 0.5f / 100.0f * affList.get((Object)affinity).floatValue();
        }
        recipe.setManaCost(base_mana_cost - base_mana_cost * modification_reduce + base_mana_cost * modification_increase);
    }

    public static final void modifyChanneled(ISpellDefinition recipe, @Nullable PlayerEntity caster) {
        if (recipe.isChanneled()) {
            float manaCostPerTick = recipe.getManaCost() / 20.0f;
            recipe.setManaCost(manaCostPerTick * 0.5f);
        }
    }

    public static final boolean checkHellfireStaff(SpellAdjustingContext context) {
        return context.stack.func_77973_b() instanceof IHellfireItem;
    }

    public static final void modifyHellfireStaff(ISpellDefinition recipe, @Nullable PlayerEntity caster) {
        if (recipe.getAffinity().containsKey((Object)Affinity.FIRE)) {
            recipe.iterateComponents(c -> {
                if (((Component)c.getPart()).getAffinity() == Affinity.FIRE) {
                    for (Attribute attr : c.getContainedAttributes()) {
                        c.setValue(attr, c.getValue(attr) * 2.0f);
                    }
                }
            });
            recipe.setOverrideAffinity(Affinity.HELLFIRE);
            recipe.setManaCost(recipe.getManaCost() * 3.0f);
        }
    }

    public static final boolean checkArcaneCrown(SpellAdjustingContext context) {
        if (context.caster == null) {
            return false;
        }
        return ((ItemStack)context.caster.field_71071_by.field_70460_b.get(EquipmentSlotType.HEAD.func_188454_b())).func_77973_b() == ItemInit.ARCANE_CROWN.get() || CuriosInterop.IsItemInCurioSlot((Item)ItemInit.ARCANE_CROWN.get(), (LivingEntity)context.caster, SlotTypePreset.HEAD);
    }

    public static final void modifyArcaneCrown(ISpellDefinition recipe, @Nullable PlayerEntity caster) {
        recipe.setManaCost(recipe.getManaCost() * 0.85f);
    }

    public static final void modifyBreakRings(ISpellDefinition recipe, @Nullable PlayerEntity caster) {
        if (caster == null) {
            return;
        }
        recipe.getComponents().stream().filter(c -> c.getPart() == SpellsInit.BREAK || c.getPart() == SpellsInit.EXCHANGE).findFirst().ifPresent(c -> {
            int magnitudeIncrease = 0;
            if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.BREAK_RING_GREATER.get(), (LivingEntity)caster).isPresent()) {
                magnitudeIncrease = 2;
            } else if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.BREAK_RING_LESSER.get(), (LivingEntity)caster).isPresent()) {
                magnitudeIncrease = 1;
            }
            for (int i = 0; i < magnitudeIncrease; ++i) {
                c.stepUp(Attribute.MAGNITUDE);
            }
        });
    }

    public static final void modifyBattlemageAmulet(ISpellDefinition recipe, @Nullable PlayerEntity caster) {
        if (caster == null) {
            return;
        }
        if (!CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.BATTLEMAGE_AMULET.get(), (LivingEntity)caster).isPresent()) {
            return;
        }
        ItemStack mainHand = caster.func_184614_ca();
        ItemStack offHand = caster.func_184592_cb();
        if (mainHand.func_77973_b() instanceof SwordItem && offHand.func_77973_b() instanceof ItemSpell || offHand.func_77973_b() instanceof SwordItem && mainHand.func_77973_b() instanceof ItemSpell) {
            recipe.getComponents().forEach(c -> c.setMultiplier(Attribute.DAMAGE, c.getMultiplier(Attribute.DAMAGE) + 0.15f));
        }
    }

    public static final boolean checkEldrinBracelet(SpellAdjustingContext context) {
        if (context.stage == SpellCastStage.SPELL_TOOLTIP || context.stage == SpellCastStage.CALCULATING_MANA_COST) {
            return ((ItemEldrinBracelet)ItemInit.ELDRIN_BRACELET.get()).isEquippedAndHasMana((LivingEntity)context.caster, 1.0f, false);
        }
        if (context.stage == SpellCastStage.CASTING && ((ItemEldrinBracelet)ItemInit.ELDRIN_BRACELET.get()).isEquippedAndHasMana((LivingEntity)context.caster, 1.0f, true)) {
            ((ItemEldrinBracelet)ItemInit.ELDRIN_BRACELET.get()).usedByPlayer(context.caster);
            return true;
        }
        return false;
    }

    public static final void modifyEldrinBracelet(ISpellDefinition recipe, @Nullable PlayerEntity caster) {
        if (caster == null) {
            return;
        }
        caster.field_70170_p.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
            BlockPos casterPos = new BlockPos(caster.func_233580_cy_().func_177958_n(), 0, caster.func_233580_cy_().func_177952_p());
            m.getWellspringRegistry().getNearbyNodes(casterPos, 0, 10).forEach((pos, node) -> {
                double dist = casterPos.func_177951_i((Vector3i)pos);
                float pctReduction = (float)(0.5 * ((100.0 - dist) / 100.0));
                recipe.setManaCost(recipe.getManaCost() - recipe.getManaCost() * pctReduction);
            });
        });
    }

    public static final boolean checkCircleOfPower(SpellAdjustingContext context) {
        if (context.caster == null) {
            return false;
        }
        if (context.stage == SpellCastStage.CASTING || context.stage == SpellCastStage.SPELL_TOOLTIP) {
            return context.caster.func_70644_a((Effect)EffectInit.CIRCLE_OF_POWER.get());
        }
        return false;
    }

    public static final void modifyCircleOfPower(ISpellDefinition recipe, @Nullable PlayerEntity caster) {
        float originalMana = recipe.getManaCost();
        int amp = caster.func_70660_b((Effect)EffectInit.CIRCLE_OF_POWER.get()).func_76458_c() + 1;
        recipe.iterateComponents(c -> c.getContainedAttributes().forEach(attr -> {
            if (attr == Attribute.SPEED) {
                c.setValue((Attribute)((Object)((Object)attr)), c.getValue((Attribute)((Object)((Object)attr))) + (float)amp);
            }
            if (attr == Attribute.DAMAGE) {
                c.setMultiplier((Attribute)((Object)((Object)attr)), 1.0f + 0.25f * (float)amp);
            }
            if (attr == Attribute.DURATION) {
                c.setMultiplier((Attribute)((Object)((Object)attr)), 2 * amp);
            }
        }));
        recipe.setManaCost(originalMana);
    }
}

