/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.effects;

import com.ma.api.capabilities.IRitualTeleportLocation;
import com.ma.api.capabilities.IWorldMagic;
import com.ma.api.rituals.IRitualContext;
import com.ma.api.rituals.RitualEffect;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.entities.EntityInit;
import com.ma.entities.rituals.EntityPortal;
import com.ma.items.ritual.ItemWorldCharm;
import com.ma.tools.TeleportHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;

public class RitualEffectReturn
extends RitualEffect {
    public RitualEffectReturn(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        if (context.getCaster() == null) {
            return false;
        }
        List<ItemStack> reagents = context.getCollectedReagents();
        if (reagents.size() == 9 && !context.getWorld().field_72995_K) {
            ServerWorld targetWorld;
            RegistryKey worldKey;
            ItemStack reagentEight = reagents.get(8);
            RegistryKey registryKey = worldKey = !reagentEight.func_190926_b() && reagentEight.func_77973_b() instanceof ItemWorldCharm ? ((ItemWorldCharm)reagentEight.func_77973_b()).GetWorldTarget(reagentEight) : context.getWorld().func_234923_W_();
            if (worldKey == null) {
                worldKey = context.getWorld().func_234923_W_();
            }
            if ((targetWorld = TeleportHelper.resolveRegistryKey((ServerWorld)context.getWorld(), worldKey.getRegistryName(), worldKey.func_240901_a_())) == null) {
                context.getCaster().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/return.world_not_found"), Util.field_240973_b_);
                return false;
            }
            LazyOptional worldMagicContainer = targetWorld.getCapability(WorldMagicProvider.MAGIC);
            if (worldMagicContainer.isPresent()) {
                IWorldMagic worldMagic = (IWorldMagic)worldMagicContainer.orElse(null);
                ArrayList<ResourceLocation> runes = new ArrayList<ResourceLocation>();
                for (int i = 0; i < 8; ++i) {
                    runes.add(reagents.get(i).func_77973_b().getRegistryName());
                }
                IRitualTeleportLocation teleportTarget = worldMagic.getRitualTeleportBlockLocation(runes, (RegistryKey<World>)worldKey);
                if (teleportTarget == null) {
                    context.getCaster().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/return.not_found"), Util.field_240973_b_);
                    return false;
                }
                Entity portal = ((EntityType)EntityInit.PORTAL_ENTITY.get()).func_220331_a((ServerWorld)context.getWorld(), null, null, context.getCenter().func_177984_a(), SpawnReason.TRIGGERED, true, false);
                if (portal != null && portal instanceof EntityPortal) {
                    ((EntityPortal)portal).setTeleportBlockPos(teleportTarget.getPos().func_177984_a(), teleportTarget.getWorldType());
                }
                return true;
            }
        }
        return true;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 20;
    }
}

