/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.effects;

import com.ma.api.rituals.IRitualContext;
import com.ma.api.sound.SFX;
import com.ma.items.ItemInit;
import com.ma.rituals.effects.RitualEffectCreateEssence;
import com.ma.tools.RLoc;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;

public class RitualEffectForgottenLore
extends RitualEffectCreateEssence {
    private static final ResourceLocation bookshelf_tag = RLoc.create("bookshelves");

    public RitualEffectForgottenLore(ResourceLocation ritualName) {
        super(ritualName, new ItemStack((IItemProvider)ItemInit.MOTE_ARCANE.get()));
    }

    @Override
    public ITextComponent canRitualStart(IRitualContext context) {
        if (this.getBookshelfLocations(context).size() < 10) {
            return new TranslationTextComponent("ritual.mana-and-artifice.forgotten_lore.no_bookshelves");
        }
        return null;
    }

    private ArrayList<BlockPos> getBookshelfLocations(IRitualContext context) {
        int searchDist = 4;
        int lb = context.getRecipe().getLowerBound();
        ArrayList<BlockPos> searched = new ArrayList<BlockPos>();
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        for (int i = -lb - 1; i <= lb + 1; ++i) {
            BlockPos a = context.getCenter().func_177982_a(-searchDist, 0, i);
            BlockPos b = context.getCenter().func_177982_a(searchDist, 0, i);
            BlockPos c = context.getCenter().func_177982_a(i, 0, -searchDist);
            BlockPos d = context.getCenter().func_177982_a(i, 0, searchDist);
            if (!searched.contains(a)) {
                searched.add(a);
            }
            if (!searched.contains(b)) {
                searched.add(b);
            }
            if (!searched.contains(c)) {
                searched.add(c);
            }
            if (searched.contains(d)) continue;
            searched.add(d);
        }
        for (BlockPos pos : searched) {
            BlockState state = context.getWorld().func_180495_p(pos);
            if (!(state.getEnchantPowerBonus((IWorldReader)context.getWorld(), pos) > 0.0f)) continue;
            found.add(pos);
        }
        return found;
    }

    @Override
    public SoundEvent getLoopSound(IRitualContext context) {
        return SFX.Loops.ARCANE;
    }

    @Override
    public boolean spawnRitualParticles(IRitualContext context) {
        ArrayList<BlockPos> shelves = this.getBookshelfLocations(context);
        if (shelves.size() == 0) {
            return false;
        }
        BlockPos end = context.getCenter().func_177984_a();
        BlockPos start = shelves.get((int)(Math.random() * (double)shelves.size()));
        context.getWorld().func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)end.func_177958_n() + 0.5, (double)end.func_177956_o() + 0.5, (double)end.func_177952_p() + 0.5, (double)(-(end.func_177958_n() - start.func_177958_n())), -0.5, (double)(-(end.func_177952_p() - start.func_177952_p())));
        return true;
    }
}

