/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.effects;

import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.rituals.IRitualContext;
import com.ma.api.rituals.RitualEffect;
import com.ma.blocks.BlockInit;
import com.ma.blocks.artifice.CoffinBlock;
import com.ma.blocks.tileentities.CoffinTile;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RitualEffectColdDark
extends RitualEffect {
    public RitualEffectColdDark(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    public ITextComponent canRitualStart(IRitualContext context) {
        IPlayerProgression progression = (IPlayerProgression)context.getCaster().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression == null) {
            return new StringTextComponent("Progression could not be found...this is a problem.");
        }
        if (progression.getTier() > 2 && progression.getAlliedFaction() != Faction.UNDEAD) {
            return new TranslationTextComponent("ritual.mana-and-artifice.progression.wrong_faction");
        }
        if (progression.getTierProgress() < 1.0f) {
            return new TranslationTextComponent("ritual.mana-and-artifice.progression.not_ready");
        }
        return null;
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        if (context.getCaster() == null || context.getCaster().func_110124_au() == null) {
            return false;
        }
        IPlayerProgression progression = (IPlayerProgression)context.getCaster().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression != null && progression.hasAlliedFaction() && progression.getAlliedFaction() != Faction.UNDEAD) {
            context.getCaster().func_145747_a((ITextComponent)new TranslationTextComponent("event.mana-and-artifice.faction_ritual_failed"), Util.field_240973_b_);
            return false;
        }
        BlockPos top_pos = context.getCenter();
        BlockPos other_pos = null;
        Direction coffin_facing = null;
        if (context.getWorld().func_175623_d(top_pos.func_177978_c())) {
            other_pos = top_pos.func_177978_c();
            coffin_facing = Direction.NORTH;
        } else if (context.getWorld().func_175623_d(top_pos.func_177974_f())) {
            other_pos = top_pos.func_177974_f();
            coffin_facing = Direction.EAST;
        } else if (context.getWorld().func_175623_d(top_pos.func_177968_d())) {
            other_pos = top_pos.func_177968_d();
            coffin_facing = Direction.SOUTH;
        } else if (context.getWorld().func_175623_d(top_pos.func_177976_e())) {
            other_pos = top_pos.func_177976_e();
            coffin_facing = Direction.WEST;
        } else {
            other_pos = top_pos.func_177978_c();
            coffin_facing = Direction.NORTH;
        }
        if (other_pos == null || coffin_facing == null) {
            return false;
        }
        context.getWorld().func_175656_a(top_pos, (BlockState)((BlockState)((CoffinBlock)BlockInit.COFFIN.get()).func_176223_P().func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.FOOT)).func_206870_a((Property)BedBlock.field_185512_D, (Comparable)coffin_facing));
        context.getWorld().func_175656_a(other_pos, (BlockState)((BlockState)((CoffinBlock)BlockInit.COFFIN.get()).func_176223_P().func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD)).func_206870_a((Property)BedBlock.field_185512_D, (Comparable)coffin_facing));
        TileEntity te = context.getWorld().func_175625_s(other_pos);
        if (te == null || !(te instanceof CoffinTile)) {
            return false;
        }
        ((CoffinTile)te).setRitualPlayer(context.getCaster());
        context.getCaster().func_145747_a((ITextComponent)new TranslationTextComponent("event.mana-and-artifice.cold_dark_prompt"), Util.field_240973_b_);
        return true;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 100;
    }
}

