/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.multiblock;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.ma.ManaAndArtifice;
import com.ma.api.blocks.tile.IMultiblockDefinition;
import com.ma.network.ClientMessageDispatcher;
import com.ma.recipes.AMRecipeBase;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.multiblock.MultiblockConfiguration;
import com.ma.recipes.multiblock.block_matchers.ExactBlockMatcher;
import com.ma.recipes.multiblock.block_matchers.IBlockMatcher;
import com.ma.recipes.multiblock.block_matchers.PedestalBlockMatcher;
import com.ma.recipes.multiblock.block_matchers.RefractionLensBlockMatcher;
import com.ma.recipes.multiblock.block_matchers.StairsBlockMatcher;
import com.ma.recipes.multiblock.block_matchers.StatelessBlockMatcher;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class MultiblockDefinition
extends AMRecipeBase
implements IMultiblockDefinition {
    private static final ArrayList<IBlockMatcher> blockMatchers;
    public static final IBlockMatcher defaultMatcher;
    public static final IBlockMatcher stairsMatcher;
    public static final IBlockMatcher statelessMatcher;
    public static final IBlockMatcher refractionLensMatcher;
    public static final IBlockMatcher pedestalMatcher;
    private ItemStack guiStack = ItemStack.field_190927_a;
    boolean isValid = false;
    boolean hasLoaded = false;
    boolean hasRequested = false;
    boolean isSymmetrical = false;
    private ResourceLocation structure;
    List<BlockState> blockStates = new ArrayList<BlockState>();
    MultiblockConfiguration structureBlocks;
    ArrayList<MultiblockConfiguration> variations = new ArrayList();
    HashMap<ResourceLocation, Integer> specialBlockMatchersByBlock = new HashMap();
    HashMap<Long, Integer> specialBlockMatchersByOffset = new HashMap();

    public MultiblockDefinition(ResourceLocation idIn) {
        super(idIn);
    }

    @Override
    protected void parseExtraJson(JsonObject object) {
        this.isValid = true;
        if (!object.has("structure")) {
            this.isValid = false;
            return;
        }
        this.structure = new ResourceLocation(object.get("structure").getAsString());
        if (object.has("matchers")) {
            JsonArray rawBlockChecks = object.get("matchers").getAsJsonArray();
            rawBlockChecks.forEach(e -> {
                if (e.isJsonObject()) {
                    JsonObject elem = e.getAsJsonObject();
                    if (elem.has("matcher") && (elem.has("offset") || elem.has("block"))) {
                        ResourceLocation matcher = new ResourceLocation(elem.get("matcher").getAsString());
                        int index = -1;
                        for (int i = 0; i < blockMatchers.size(); ++i) {
                            if (!blockMatchers.get(i).getId().toString().equals(matcher.toString())) continue;
                            index = i;
                            break;
                        }
                        if (index > -1) {
                            if (elem.has("offset")) {
                                long offset = elem.get("offset").getAsLong();
                                this.specialBlockMatchersByOffset.put(offset, index);
                            } else {
                                ResourceLocation block = new ResourceLocation(elem.get("block").getAsString());
                                this.specialBlockMatchersByBlock.put(block, index);
                            }
                        } else {
                            ManaAndArtifice.LOGGER.warn("Misconfigured special block match in " + this.func_199560_c().toString() + ": matcher '" + matcher.toString() + "' could not be resolved.");
                        }
                    } else {
                        ManaAndArtifice.LOGGER.warn("Misconfigured special block match in " + this.func_199560_c().toString() + ": missing matcher and (offset or block id)");
                    }
                }
            });
        }
        if (object.has("symmetrical")) {
            this.isSymmetrical = object.get("symmetrical").getAsBoolean();
        }
        if (object.has("replacements")) {
            JsonArray replacements = object.get("replacements").getAsJsonArray();
            replacements.forEach(r -> {
                JsonObject replacement;
                MultiblockConfiguration variation;
                if (r.isJsonObject() && (variation = MultiblockConfiguration.parseVariation(replacement = r.getAsJsonObject(), this.blockStates)).getIsValid()) {
                    this.variations.add(variation);
                }
            });
        }
    }

    private boolean tryLoadStructure(World world) {
        if (!this.hasLoaded) {
            if (world instanceof ServerWorld) {
                if (!this.isValid) {
                    return false;
                }
                this.structureBlocks = MultiblockConfiguration.loadStructure(((ServerWorld)world).func_184163_y(), this.structure, this.blockStates);
                this.hasLoaded = this.structureBlocks.getIsValid();
            } else if (!this.hasRequested) {
                this.structureBlocks = MultiblockConfiguration.createDummyStructure();
                ClientMessageDispatcher.sendMultiblockSyncRequestMessage((LivingEntity)ManaAndArtifice.instance.proxy.getClientPlayer(), this.func_199560_c());
                this.hasRequested = true;
            }
        }
        return this.hasLoaded;
    }

    @Override
    public boolean spawn(ServerWorld world, BlockPos origin) {
        return this.spawn(world, origin, Rotation.NONE, true);
    }

    @Override
    public boolean spawn(ServerWorld world, BlockPos origin, Rotation rotation, boolean centerOffset) {
        if (!this.isValid) {
            return false;
        }
        if (!this.tryLoadStructure((World)world)) {
            return false;
        }
        if (centerOffset) {
            origin = origin.func_177973_b(new Vector3i(this.getSize().func_177958_n() / 2, 0, this.getSize().func_177952_p() / 2));
        }
        this.structureBlocks.resetMatchData();
        this.structureBlocks.rotate(rotation);
        this.variations.forEach(v -> {
            v.resetMatchData();
            v.rotate(rotation);
        });
        BlockPos fOrigin = origin;
        this.structureBlocks.getOffsets().forEach(packedOffset -> {
            BlockPos offset = BlockPos.func_218283_e((long)packedOffset);
            BlockPos worldPos = fOrigin.func_177971_a((Vector3i)offset);
            int blockStateIndex = this.structureBlocks.getBlockAt(offset);
            if (blockStateIndex < 0 || blockStateIndex >= this.blockStates.size()) {
                this.isValid = false;
                return;
            }
            BlockState desiredState = this.blockStates.get(blockStateIndex);
            world.func_175656_a(worldPos, desiredState);
        });
        return true;
    }

    @Override
    public boolean match(World world, BlockPos origin) {
        return this.match(world, origin, Rotation.NONE, true);
    }

    @Override
    public boolean match(World world, BlockPos origin, Rotation rotation, boolean centerOffset) {
        Pair<Integer, Integer> matchCount = this.matchWithCount(world, origin, rotation, centerOffset);
        return ((Integer)matchCount.getFirst()).equals(matchCount.getSecond());
    }

    @Override
    public Pair<Integer, Integer> matchWithCount(World world, BlockPos origin, Rotation rotation, boolean centerOffset) {
        if (!this.isValid) {
            return new Pair((Object)0, (Object)1);
        }
        if (!this.tryLoadStructure(world)) {
            return new Pair((Object)0, (Object)1);
        }
        if (world.field_72995_K && !this.hasLoaded) {
            return new Pair((Object)0, (Object)1);
        }
        if (centerOffset) {
            origin = origin.func_177973_b(new Vector3i(this.getSize().func_177958_n() / 2, 0, this.getSize().func_177952_p() / 2));
        }
        this.structureBlocks.resetMatchData();
        this.structureBlocks.rotate(rotation);
        this.variations.forEach(v -> {
            v.resetMatchData();
            v.rotate(rotation);
        });
        BlockPos fOrigin = origin;
        this.structureBlocks.getOffsets().forEach(packedOffset -> {
            BlockPos offset = BlockPos.func_218283_e((long)packedOffset);
            BlockPos worldPos = fOrigin.func_177971_a((Vector3i)offset);
            BlockState worldState = world.func_180495_p(worldPos);
            int blockStateIndex = this.structureBlocks.getBlockAt(offset);
            if (blockStateIndex < 0 || blockStateIndex >= this.blockStates.size()) {
                this.isValid = false;
                return;
            }
            BlockState desiredState = this.blockStates.get(blockStateIndex);
            if (this.matchBlockState(world, offset, worldPos, worldState, desiredState)) {
                this.structureBlocks.markMatch(offset);
            }
            this.variations.forEach(variation -> {
                int variationStateIndex = variation.getBlockAt(offset);
                if (variationStateIndex < 0 || blockStateIndex >= this.blockStates.size()) {
                    return;
                }
                BlockState variationState = this.blockStates.get(variationStateIndex);
                if (this.matchBlockState(world, offset, worldPos, worldState, variationState)) {
                    variation.markMatch(offset);
                }
            });
        });
        this.variations.forEach(v -> v.computeMatch());
        List<MultiblockConfiguration> matchedVariations = this.variations.stream().filter(v -> v.matched()).collect(Collectors.toList());
        return this.structureBlocks.matchCount(matchedVariations);
    }

    @Override
    public int getBlockCount() {
        if (!this.isValid || !this.hasLoaded) {
            return 1;
        }
        return this.structureBlocks.countBlocks();
    }

    @Override
    @Nullable
    public HashMap<BlockPos, BlockState> getMissingBlocks(World world, BlockPos origin, Rotation rotation, boolean centerOffset) {
        if (!this.tryLoadStructure(world)) {
            return null;
        }
        if (world.field_72995_K && !this.hasLoaded) {
            return null;
        }
        if (!this.isValid) {
            return null;
        }
        if (centerOffset) {
            origin = origin.func_177973_b(new Vector3i(this.getSize().func_177958_n() / 2, 0, this.getSize().func_177952_p() / 2));
        }
        HashMap<BlockPos, BlockState> missingBlocks = new HashMap<BlockPos, BlockState>();
        BlockPos fOrigin = origin;
        this.structureBlocks.getOffsets().forEach(packedOffset -> {
            BlockPos offset = BlockPos.func_218283_e((long)packedOffset);
            BlockPos worldPos = fOrigin.func_177971_a((Vector3i)offset);
            BlockState worldState = world.func_180495_p(worldPos);
            int blockStateIndex = this.structureBlocks.getBlockAt(offset);
            if (blockStateIndex < 0 || blockStateIndex >= this.blockStates.size()) {
                this.isValid = false;
                return;
            }
            BlockState desiredState = this.blockStates.get(blockStateIndex);
            if (!this.matchBlockState(world, offset, worldPos, worldState, desiredState)) {
                missingBlocks.put(worldPos, desiredState);
            }
        });
        this.variations.stream().forEach(v -> v.getOffsets().forEach(packedOffset -> {
            BlockPos offset = BlockPos.func_218283_e((long)packedOffset);
            BlockPos worldPos = fOrigin.func_177971_a((Vector3i)offset);
            BlockState worldState = world.func_180495_p(worldPos);
            int blockStateIndex = v.getBlockAt(offset);
            if (blockStateIndex < 0 || blockStateIndex >= this.blockStates.size()) {
                this.isValid = false;
                return;
            }
            BlockState desiredState = this.blockStates.get(blockStateIndex);
            if (this.matchBlockState(world, offset, worldPos, worldState, desiredState)) {
                missingBlocks.remove(worldPos);
            }
        }));
        return missingBlocks;
    }

    @Override
    public List<String> getMatchedVariations() {
        return this.variations.stream().filter(v -> v.matched()).map(v -> v.identifier).collect(Collectors.toList());
    }

    @Override
    public boolean isSymmetrical() {
        return this.isSymmetrical;
    }

    private boolean matchBlockState(World world, BlockPos offset, BlockPos worldPos, BlockState existing, BlockState desired) {
        int matcherIndex = -1;
        if (this.specialBlockMatchersByOffset.containsKey(offset.func_218275_a())) {
            matcherIndex = this.specialBlockMatchersByOffset.get(offset.func_218275_a());
        } else if (this.specialBlockMatchersByBlock.containsKey(desired.func_177230_c().getRegistryName())) {
            matcherIndex = this.specialBlockMatchersByBlock.get(desired.func_177230_c().getRegistryName());
        }
        if (matcherIndex > -1) {
            return blockMatchers.get(matcherIndex).match(world, offset, worldPos, desired, existing, true);
        }
        if (desired.func_177230_c() instanceof StairsBlock) {
            return stairsMatcher.match(world, offset, worldPos, desired, existing, true);
        }
        return defaultMatcher.match(world, offset, worldPos, desired, existing, true);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return false;
    }

    public ItemStack assemble(CraftingInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeInit.MULTIBLOCK_RECIPE_SERIALIZER.get();
    }

    @Override
    public ItemStack getGuiRepresentationStack() {
        return this.func_77571_b();
    }

    public ItemStack func_77571_b() {
        if (this.guiStack.func_190926_b()) {
            this.guiStack = new ItemStack((IItemProvider)Items.field_192397_db);
            this.guiStack.func_200302_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:multiblock_recipe").func_230529_a_((ITextComponent)new TranslationTextComponent(this.func_199560_c().toString())));
        }
        return this.guiStack;
    }

    @Override
    public ResourceLocation getStructurePath() {
        return this.structure;
    }

    @Override
    public Vector3i getSize() {
        if (!this.hasLoaded) {
            return Vector3i.field_177959_e;
        }
        return this.structureBlocks.getSize();
    }

    @Override
    public void setStructurePath(ResourceLocation path) {
        this.structure = path;
    }

    @Override
    public HashMap<ResourceLocation, Integer> getSpecialBlockMatchersByBlock() {
        return this.specialBlockMatchersByBlock;
    }

    @Override
    public void setSpecialBlockMatchersByBlock(HashMap<ResourceLocation, Integer> matchers) {
        this.specialBlockMatchersByBlock = matchers;
    }

    @Override
    public HashMap<Long, Integer> getSpecialBlockMatchersByOffset() {
        return this.specialBlockMatchersByOffset;
    }

    @Override
    public void setSpecialBlockMatchersByOffset(HashMap<Long, Integer> matchers) {
        this.specialBlockMatchersByOffset = matchers;
    }

    public CompoundNBT serializeVariations() {
        CompoundNBT data = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (MultiblockConfiguration conf : this.variations) {
            list.add((Object)conf.serialize());
        }
        data.func_218657_a("list", (INBT)list);
        return data;
    }

    public void deserializeVariations(CompoundNBT data) {
        if (data.func_74764_b("list")) {
            ListNBT list = data.func_150295_c("list", 10);
            this.variations.clear();
            list.forEach(e -> {
                CompoundNBT entry = (CompoundNBT)e;
                MultiblockConfiguration conf = MultiblockConfiguration.deserialize(entry);
                if (conf.getIsValid()) {
                    this.variations.add(conf);
                }
            });
        }
    }

    public CompoundNBT serializeCoreBlocks(ServerWorld world) {
        if (!this.isValid) {
            return new CompoundNBT();
        }
        if (!this.tryLoadStructure((World)world)) {
            return new CompoundNBT();
        }
        CompoundNBT data = new CompoundNBT();
        data.func_218657_a("offsets", (INBT)this.structureBlocks.serialize());
        ListNBT states = new ListNBT();
        this.blockStates.forEach(state -> states.add((Object)NBTUtil.func_190009_a((BlockState)state)));
        data.func_218657_a("states", (INBT)states);
        return data;
    }

    public void deserializeCoreBlocks(CompoundNBT data) {
        this.blockStates = new ArrayList<BlockState>();
        if (data.func_74764_b("offsets")) {
            this.structureBlocks = MultiblockConfiguration.deserialize(data.func_74775_l("offsets"));
        }
        if (data.func_150297_b("states", 9)) {
            ListNBT states = (ListNBT)data.func_74781_a("states");
            states.forEach(a -> this.blockStates.add(NBTUtil.func_190008_d((CompoundNBT)((CompoundNBT)a))));
        }
        this.isValid = this.structureBlocks.getIsValid() && this.blockStates.size() > 0;
        this.hasLoaded = true;
    }

    public void setBlockStates(List<BlockState> states) {
        this.blockStates = states;
    }

    public void setStructure(MultiblockConfiguration mainStructure) {
        this.structureBlocks = mainStructure;
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeInit.MULTIBLOCK_TYPE;
    }

    @Nullable
    public List<List<ItemStack>> getBlocksList(World world) {
        if (!this.tryLoadStructure(world)) {
            return null;
        }
        if (world.field_72995_K && !this.hasLoaded) {
            return null;
        }
        HashMap blockCounts = new HashMap();
        this.structureBlocks.structureBlocks.entrySet().forEach(e -> {
            BlockState state = this.blockStates.get((Integer)((Pair)e.getValue()).getFirst());
            if (!state.func_196958_f()) {
                blockCounts.put(state.func_177230_c(), blockCounts.getOrDefault(state.func_177230_c(), 0) + 1);
            }
        });
        ArrayList<List<ItemStack>> blocksList = new ArrayList<List<ItemStack>>();
        blockCounts.entrySet().forEach(e -> {
            List<Object> valid = this.getValidBlocksFor((Block)e.getKey());
            valid.forEach(s -> s.func_190920_e(((Integer)e.getValue()).intValue()));
            valid = valid.stream().filter(s -> !s.func_190926_b()).collect(Collectors.toList());
            if (valid.size() > 0) {
                blocksList.add(valid);
            }
        });
        return blocksList;
    }

    private ArrayList<ItemStack> getValidBlocksFor(Block block) {
        int matcherIndex = this.specialBlockMatchersByBlock.getOrDefault(block.getRegistryName(), -1);
        if (matcherIndex > -1) {
            return blockMatchers.get(matcherIndex).getValidBlocks(block);
        }
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        out.add(new ItemStack((IItemProvider)block));
        return out;
    }

    @Override
    public List<BlockPos> getPositions(ResourceLocation blockType, @Nullable Predicate<BlockState> predicate) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.structureBlocks.structureBlocks.forEach((l, p) -> {
            BlockState state = this.blockStates.get((Integer)p.getFirst());
            if (state != null) {
                if (predicate != null && !predicate.test(state)) {
                    return;
                }
                if (!state.func_177230_c().getRegistryName().equals((Object)blockType)) {
                    return;
                }
                positions.add(BlockPos.func_218283_e((long)l));
            }
        });
        return positions;
    }

    @Override
    public List<BlockPos> getPositions(List<ResourceLocation> blockTypes, @Nullable Predicate<BlockState> predicate) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.structureBlocks.structureBlocks.forEach((l, p) -> {
            BlockState state = this.blockStates.get((Integer)p.getFirst());
            if (state != null) {
                if (predicate != null && !predicate.test(state)) {
                    return;
                }
                if (blockTypes.stream().noneMatch(s -> state.func_177230_c().getRegistryName().equals(s))) {
                    return;
                }
                positions.add(BlockPos.func_218283_e((long)l));
            }
        });
        return positions;
    }

    static {
        defaultMatcher = new ExactBlockMatcher();
        stairsMatcher = new StairsBlockMatcher();
        statelessMatcher = new StatelessBlockMatcher();
        refractionLensMatcher = new RefractionLensBlockMatcher();
        pedestalMatcher = new PedestalBlockMatcher();
        blockMatchers = new ArrayList();
        blockMatchers.add(stairsMatcher);
        blockMatchers.add(statelessMatcher);
        blockMatchers.add(refractionLensMatcher);
        blockMatchers.add(pedestalMatcher);
    }
}

