/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.arcanefurnace;

import com.google.gson.JsonObject;
import com.ma.recipes.AMRecipeBase;
import com.ma.recipes.RecipeInit;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class ArcaneFurnaceRecipe
extends AMRecipeBase {
    private ResourceLocation inputItem;
    private ResourceLocation outputItem;
    private int burnTime;
    private int outputQuantity = 1;
    private Item __outputItem = null;

    public ArcaneFurnaceRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    @Override
    public void parseExtraJson(JsonObject object) {
        if (object.has("input") && object.has("output") && object.has("burnTime")) {
            this.inputItem = new ResourceLocation(object.get("input").getAsString());
            this.outputItem = new ResourceLocation(object.get("output").getAsString());
            this.burnTime = object.get("burnTime").getAsInt();
        }
        if (object.has("outputQuantity")) {
            this.outputQuantity = object.get("outputQuantity").getAsInt();
        }
    }

    public void setInputItem(ResourceLocation rLoc) {
        this.inputItem = rLoc;
    }

    public ResourceLocation getInputItem() {
        return this.inputItem;
    }

    public void setOutputItem(ResourceLocation rLoc) {
        this.outputItem = rLoc;
    }

    public ResourceLocation getOutputItem() {
        return this.outputItem;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getOutputQuantity() {
        return this.outputQuantity;
    }

    public void setOutputQuantity(int quantity) {
        this.outputQuantity = quantity;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        if (inv.func_70302_i_() != 1) {
            return false;
        }
        ItemStack stack = inv.func_70301_a(0);
        return stack.func_77973_b().getRegistryName().equals((Object)this.inputItem);
    }

    public ItemStack func_77571_b() {
        IForgeRegistry itemRegistry;
        if (this.__outputItem == null && (itemRegistry = GameRegistry.findRegistry(Item.class)) != null) {
            this.__outputItem = (Item)itemRegistry.getValue(this.outputItem);
        }
        if (this.__outputItem != null) {
            return new ItemStack((IItemProvider)this.__outputItem, this.outputQuantity);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack assemble(CraftingInventory inv) {
        return this.func_77571_b();
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeInit.ARCANE_FURNACE_RECIPE_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeInit.ARCANE_FURNACE_TYPE;
    }

    @Override
    public ItemStack getGuiRepresentationStack() {
        return this.func_77571_b();
    }
}

