/*
 * Decompiled with CFR 0.152.
 */
package com.ma.particles.trail;

import com.ma.api.particles.MAParticleType;
import com.ma.particles.FXMovementType;
import com.ma.particles.base.MAParticleBase;
import com.ma.particles.bolt.Segment;
import com.ma.particles.trail.ParticleTrail;
import com.ma.tools.math.Vector3;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FXTrail
extends MAParticleBase {
    private ParticleTrail data;
    private Entity followEntity;
    private Vector3 origin;
    private static final IParticleRenderType LIGHTNING_BOLT_RENDER = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder bufferBuilder, TextureManager textureManager) {
            FXTrail.beginRenderCommon(bufferBuilder, textureManager);
        }

        public void func_217599_a(Tessellator tessellator) {
            tessellator.func_78381_a();
            FXTrail.endRenderCommon();
        }

        public String toString() {
            return "mana-and-artifice:trail";
        }
    };

    public FXTrail(ClientWorld worldIn, double startX, double startY, double startZ, double entityID, double randSeed, double maxAge, IAnimatedSprite sprite) {
        super(worldIn, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.field_217569_E = sprite.func_217590_a(this.field_187136_p);
        this.data = new ParticleTrail(worldIn.field_73012_v.nextLong());
        this.func_187109_b(startX, startY, startZ);
        this.field_187129_i = 0.0;
        this.field_187130_j = 0.0;
        this.field_187131_k = 0.0;
        this.origin = new Vector3(startX, startY, startZ);
        this.field_70544_f = 0.04f;
        this.func_187115_a(3.0f, 3.0f);
        this.field_70552_h = 0.2f;
        this.field_70553_i = 0.2f;
        this.field_70551_j = 0.8f;
    }

    private void setMoveFollowEntity(World world, int entityID, long seed, int maxAge) {
        this.followEntity = world.func_73045_a(entityID);
        this.field_70547_e = maxAge;
        this.movementType = FXMovementType.STATIONARY;
        this.origin = null;
    }

    @Override
    public void func_189213_a() {
        if (this.followEntity == null) {
            super.func_189213_a();
        } else {
            this.moveFollowEntity();
        }
        double time = (float)this.field_70546_d / 4.0f;
        Vector3 prevPos = new Vector3(this.field_187123_c, this.field_187124_d, this.field_187125_e);
        Vector3 curPos = new Vector3(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        curPos = curPos.add(new Vector3(Math.sin(time), Math.cos(time), Math.sin(time)).scale(0.2f));
        if (this.field_70546_d > 5) {
            this.data.tick(prevPos, curPos);
        }
    }

    private void moveFollowEntity() {
        if (this.field_70547_e == -1) {
            if (this.followEntity == null || !this.followEntity.func_70089_S()) {
                this.func_187112_i();
            } else {
                this.field_187133_m = false;
            }
        } else {
            ++this.field_70546_d;
            if (this.field_70546_d > this.field_70547_e) {
                this.func_187112_i();
            }
        }
        if (!this.field_187133_m) {
            this.field_187123_c = this.followEntity.field_70169_q;
            this.field_187124_d = this.followEntity.field_70167_r;
            this.field_187125_e = this.followEntity.field_70166_s;
            this.func_187109_b(this.followEntity.func_226277_ct_(), this.followEntity.func_226278_cu_(), this.followEntity.func_226281_cx_());
        }
    }

    public boolean shouldCull() {
        return false;
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        Vector3 particleOrigin;
        Vector3d vec3d = renderInfo.func_216785_c();
        double lerpX = MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f);
        double lerpY = MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g);
        double lerpZ = MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h);
        float f = (float)(lerpX - vec3d.func_82615_a());
        float f1 = (float)(lerpY - vec3d.func_82617_b());
        float f2 = (float)(lerpZ - vec3d.func_82616_c());
        Vector3 renderViewOffset = new Vector3(f, f1, f2);
        Vector3 vector3 = particleOrigin = this.origin != null ? this.origin : new Vector3(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        if (this.origin != null) {
            Vector3 originDelta = new Vector3(lerpX, lerpY, lerpZ).sub(particleOrigin);
            particleOrigin = particleOrigin.add(originDelta);
        }
        int count = 0;
        Vector3 lastEnd1 = null;
        Vector3 lastEnd2 = null;
        for (Segment s : this.data.getSegments()) {
            float width = this.field_70544_f;
            Vector3 start = s.getStart().sub(particleOrigin);
            Vector3 end = s.getEnd().sub(particleOrigin);
            Vector3 dir = end.sub(start).normalize().scale(5.0E-4f);
            Vector3[] avector3f = new Vector3[]{lastEnd1 == null ? start.add(new Vector3(-width, 0.0, -width)) : lastEnd1.sub(dir), lastEnd2 == null ? start.add(new Vector3(-width, 0.0, width)) : lastEnd2.sub(dir), end.add(new Vector3(width, 0.0, width)), end.add(new Vector3(width, 0.0, -width))};
            lastEnd1 = avector3f[2];
            lastEnd2 = avector3f[3];
            for (int i = 0; i < 4; ++i) {
                avector3f[i] = avector3f[i].add(renderViewOffset);
            }
            float startAlpha = this.field_82339_as;
            if (count > this.data.getSegments().size() - 10) {
                startAlpha = 0.1f * (float)(this.data.getSegments().size() - count);
            }
            float minU = this.func_217563_c();
            float maxU = this.func_217564_d();
            float minV = this.func_217562_e();
            float maxV = this.func_217560_f();
            int j = 0xF000F0;
            buffer.func_225582_a_((double)avector3f[3].x, (double)avector3f[3].y, (double)avector3f[3].z).func_225583_a_(maxU, maxV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
            buffer.func_225582_a_((double)avector3f[2].x, (double)avector3f[2].y, (double)avector3f[2].z).func_225583_a_(maxU, minV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
            buffer.func_225582_a_((double)avector3f[0].x, (double)avector3f[0].y, (double)avector3f[0].z).func_225583_a_(minU, minV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
            buffer.func_225582_a_((double)avector3f[1].x, (double)avector3f[1].y, (double)avector3f[1].z).func_225583_a_(minU, maxV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, startAlpha).func_227886_a_(j).func_181675_d();
            buffer.func_225582_a_((double)avector3f[3].x, (double)avector3f[3].y, (double)avector3f[3].z).func_225583_a_(maxU, maxV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
            buffer.func_225582_a_((double)avector3f[2].x, (double)avector3f[2].y, (double)avector3f[2].z).func_225583_a_(maxU, minV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
            buffer.func_225582_a_((double)avector3f[0].x, (double)avector3f[0].y, (double)avector3f[0].z).func_225583_a_(minU, minV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
            buffer.func_225582_a_((double)avector3f[1].x, (double)avector3f[1].y, (double)avector3f[1].z).func_225583_a_(minU, maxV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, startAlpha).func_227886_a_(j).func_181675_d();
            ++count;
        }
    }

    @Override
    public IParticleRenderType func_217558_b() {
        return LIGHTNING_BOLT_RENDER;
    }

    protected static void beginRenderCommon(BufferBuilder buffer, TextureManager textureManager) {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.alphaFunc((int)516, (float)0.003921569f);
        RenderSystem.disableLighting();
        textureManager.func_110577_a(AtlasTexture.field_215262_g);
        Texture tex = textureManager.func_229267_b_(AtlasTexture.field_215262_g);
        tex.setBlurMipmap(true, false);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
    }

    protected static void endRenderCommon() {
        Minecraft.func_71410_x().field_71446_o.func_229267_b_(AtlasTexture.field_215262_g).restoreLastBlurMipmap();
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXTrailBezierFactory
    extends MAParticleBase.FXParticleFactoryBase {
        public FXTrailBezierFactory(IAnimatedSprite spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(MAParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXTrail particle = new FXTrail(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            particle.setMoveBezier(x, y, z, xSpeed, ySpeed, zSpeed);
            this.configureParticle(particle, typeIn);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXTrailSphereOrbitFactory
    extends MAParticleBase.FXParticleFactoryBase {
        public FXTrailSphereOrbitFactory(IAnimatedSprite spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(MAParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXTrail particle = new FXTrail(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            particle.setMoveSphereOrbit(x, y, z, xSpeed, ySpeed, zSpeed);
            this.configureParticle(particle, typeIn);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXTrailOrbitFactory
    extends MAParticleBase.FXParticleFactoryBase {
        public FXTrailOrbitFactory(IAnimatedSprite spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(MAParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXTrail particle = new FXTrail(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            particle.setMoveOrbit(x, y, z, xSpeed, ySpeed, zSpeed);
            particle.field_70547_e = 50;
            this.configureParticle(particle, typeIn);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXTrailVelocityFactory
    extends MAParticleBase.FXParticleFactoryBase {
        public FXTrailVelocityFactory(IAnimatedSprite spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(MAParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXTrail particle = new FXTrail(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            particle.setMoveVelocity(xSpeed, ySpeed, zSpeed, false);
            this.configureParticle(particle, typeIn);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXTrailFollowEntityFactory
    extends MAParticleBase.FXParticleFactoryBase {
        public FXTrailFollowEntityFactory(IAnimatedSprite spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(MAParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXTrail particle = new FXTrail(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            particle.setMoveFollowEntity((World)worldIn, (int)xSpeed, (long)ySpeed, (int)zSpeed);
            this.configureParticle(particle, typeIn);
            return particle;
        }
    }
}

