/*
 * Decompiled with CFR 0.152.
 */
package com.ma.particles;

import com.ma.api.particles.MAParticleType;
import com.ma.particles.base.MAParticleBase;
import com.ma.tools.math.MathUtils;
import com.ma.tools.math.Vector3;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FXEnder
extends MAParticleBase {
    private static final IParticleRenderType ENDER_RENDER = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder bufferBuilder, TextureManager textureManager) {
            FXEnder.beginRenderCommon(bufferBuilder, textureManager);
        }

        public void func_217599_a(Tessellator tessellator) {
            tessellator.func_78381_a();
            FXEnder.endRenderCommon();
        }

        public String toString() {
            return "mana-and-artifice:ender";
        }
    };

    public FXEnder(ClientWorld world, double x, double y, double z, IAnimatedSprite sprite) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.field_187130_j *= (double)0.2f;
        this.field_187129_i = 0.0;
        this.field_187131_k = 0.0;
        this.field_190015_G = this.field_190014_F = (float)(-45.0 + Math.random() * 90.0 / (Math.PI / 180));
        this.field_70544_f *= 0.35f;
        this.field_70547_e = 30;
        this.field_190017_n = false;
        this.field_217569_E = sprite.func_217590_a(new Random());
    }

    private void setupColorTransitions() {
        this.func_82338_g(0.0f);
        this.colorTransitions.add(new Vector3(0.5490196347236633, 0.2627451f, 0.5764706134796143));
        this.colorTransitions.add(new Vector3(0.0, 0.0, 0.0));
        this.func_70538_b(((Vector3)this.colorTransitions.get((int)0)).x, ((Vector3)this.colorTransitions.get((int)0)).y, ((Vector3)this.colorTransitions.get((int)0)).z);
    }

    public float func_217561_b(float partialTicks) {
        return this.field_70544_f * (1.0f + (float)this.field_70546_d / (float)this.field_70547_e * 4.0f);
    }

    public Vector3 getPosition() {
        return new Vector3(this.field_187126_f, this.field_187127_g, this.field_187128_h);
    }

    @Override
    protected int func_189214_a(float partialTick) {
        return 0xF00000;
    }

    @Override
    protected boolean apply_aging() {
        super.apply_aging();
        Vector3 startColor = (Vector3)this.colorTransitions.get(0);
        Vector3 endColor = (Vector3)this.colorTransitions.get(1);
        float agePct = MathUtils.clamp01((float)this.field_70546_d / (float)this.field_70547_e);
        Vector3 color = Vector3.lerp(startColor, endColor, agePct);
        this.func_70538_b(color.x, color.y, color.z);
        return this.field_187133_m;
    }

    @Override
    @Nonnull
    public IParticleRenderType func_217558_b() {
        return ENDER_RENDER;
    }

    protected static void beginRenderCommon(BufferBuilder buffer, TextureManager textureManager) {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.alphaFunc((int)516, (float)0.003921569f);
        RenderSystem.disableLighting();
        textureManager.func_110577_a(AtlasTexture.field_215262_g);
        Texture tex = textureManager.func_229267_b_(AtlasTexture.field_215262_g);
        tex.setBlurMipmap(true, false);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
    }

    protected static void endRenderCommon() {
        Minecraft.func_71410_x().field_71446_o.func_229267_b_(AtlasTexture.field_215262_g).restoreLastBlurMipmap();
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXEnderVelocity
    extends MAParticleBase.FXParticleFactoryBase {
        public FXEnderVelocity(IAnimatedSprite spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(MAParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXEnder particle = new FXEnder(worldIn, x, y, z, this.spriteSet);
            particle.setMoveVelocity(xSpeed, ySpeed, zSpeed, true);
            particle.setupColorTransitions();
            this.configureParticle(particle, typeIn);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXEnderBezier
    extends MAParticleBase.FXParticleFactoryBase {
        public FXEnderBezier(IAnimatedSprite spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(MAParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXEnder particle = new FXEnder(worldIn, x, y, z, this.spriteSet);
            particle.setMoveBezier(x, y, z, xSpeed, ySpeed, zSpeed);
            particle.setupColorTransitions();
            this.configureParticle(particle, typeIn);
            return particle;
        }
    }
}

