/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_server;

import com.ma.ManaAndArtifice;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.network.messages.BaseMessage;
import net.minecraft.network.PacketBuffer;

public class AnimatedConstructSyncRequestMessage
extends BaseMessage {
    private int entityID;
    private boolean diagnosticsOnly;

    private AnimatedConstructSyncRequestMessage() {
        this.messageIsValid = false;
    }

    public AnimatedConstructSyncRequestMessage(int entityID, boolean diagnosticsOnly) {
        this();
        this.entityID = entityID;
        this.diagnosticsOnly = diagnosticsOnly;
        this.messageIsValid = true;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public boolean getDiagnosticsOnly() {
        return this.diagnosticsOnly;
    }

    public static AnimatedConstructSyncRequestMessage decode(PacketBuffer buf) {
        AnimatedConstructSyncRequestMessage msg = new AnimatedConstructSyncRequestMessage();
        try {
            msg.entityID = buf.readInt();
            msg.diagnosticsOnly = buf.readBoolean();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading AnimatedConstructSyncMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(AnimatedConstructSyncRequestMessage msg, PacketBuffer buf) {
        buf.writeInt(msg.getEntityID());
        buf.writeBoolean(msg.diagnosticsOnly);
    }

    public static AnimatedConstructSyncRequestMessage fromConstruct(EntityAnimatedConstruct construct, boolean diagnosticsOnly) {
        AnimatedConstructSyncRequestMessage msg = new AnimatedConstructSyncRequestMessage(construct.func_145782_y(), diagnosticsOnly);
        return msg;
    }
}

