/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_client;

import com.ma.ManaAndArtifice;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.network.messages.BaseMessage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WellspringPowerNetworkSyncMessage
extends BaseMessage {
    CompoundNBT wellspringData;
    private RegistryKey<World> forDimension;

    public WellspringPowerNetworkSyncMessage(CompoundNBT nbt, RegistryKey<World> dimension) {
        this.wellspringData = nbt;
        this.messageIsValid = true;
        this.forDimension = dimension;
    }

    private WellspringPowerNetworkSyncMessage() {
        this.messageIsValid = false;
    }

    public CompoundNBT getData() {
        return this.wellspringData;
    }

    public RegistryKey<World> getDimension() {
        return this.forDimension;
    }

    public static WellspringPowerNetworkSyncMessage decode(PacketBuffer buf) {
        WellspringPowerNetworkSyncMessage msg = new WellspringPowerNetworkSyncMessage();
        try {
            msg.wellspringData = buf.func_150793_b();
            ResourceLocation location = buf.func_192575_l();
            ResourceLocation registryName = buf.func_192575_l();
            msg.forDimension = new RegistryKey(registryName, location);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading WellspringPowerNetworkSyncMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(WellspringPowerNetworkSyncMessage msg, PacketBuffer buf) {
        buf.func_150786_a(msg.getData());
        buf.func_192572_a(msg.forDimension.func_240901_a_());
        buf.func_192572_a(msg.forDimension.getRegistryName());
    }

    public static WellspringPowerNetworkSyncMessage from(ServerWorld world, ServerPlayerEntity player, boolean fullSync) {
        CompoundNBT nbt = new CompoundNBT();
        world.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.getWellspringRegistry().serializeNetworkStrength((PlayerEntity)player, nbt, fullSync));
        return new WellspringPowerNetworkSyncMessage(nbt, (RegistryKey<World>)world.func_234923_W_());
    }
}

