/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_client;

import com.ma.ManaAndArtifice;
import com.ma.network.messages.BaseMessage;
import net.minecraft.item.MerchantOffers;
import net.minecraft.network.PacketBuffer;

public class WanderingWizardInventoryMessage
extends BaseMessage {
    private int containerId;
    private MerchantOffers offers;
    private int level;
    private int xp;
    private boolean hasXPBar;
    private boolean canRestock;
    private boolean isFinalized;

    public WanderingWizardInventoryMessage() {
        this.messageIsValid = false;
    }

    public WanderingWizardInventoryMessage(int id, MerchantOffers offersIn, int levelIn, int xpIn, boolean hasXPBar, boolean canRestock, boolean isFinal) {
        this.containerId = id;
        this.offers = offersIn;
        this.level = levelIn;
        this.xp = xpIn;
        this.hasXPBar = hasXPBar;
        this.canRestock = canRestock;
        this.isFinalized = isFinal;
        this.messageIsValid = true;
    }

    public static WanderingWizardInventoryMessage decode(PacketBuffer buf) {
        WanderingWizardInventoryMessage msg = new WanderingWizardInventoryMessage();
        try {
            msg.containerId = buf.func_150792_a();
            msg.offers = MerchantOffers.func_222198_b((PacketBuffer)buf);
            msg.level = buf.func_150792_a();
            msg.xp = buf.func_150792_a();
            msg.hasXPBar = buf.readBoolean();
            msg.canRestock = buf.readBoolean();
            msg.isFinalized = buf.readBoolean();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading WanderingWizardInventoryMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(WanderingWizardInventoryMessage message, PacketBuffer buf) {
        buf.func_150787_b(message.containerId);
        message.offers.func_222196_a(buf);
        buf.func_150787_b(message.level);
        buf.func_150787_b(message.xp);
        buf.writeBoolean(message.hasXPBar);
        buf.writeBoolean(message.canRestock);
        buf.writeBoolean(message.isFinalized);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public MerchantOffers getOffers() {
        return this.offers;
    }

    public int getLevel() {
        return this.level;
    }

    public int getExp() {
        return this.xp;
    }

    public boolean getHasXPBar() {
        return this.hasXPBar;
    }

    public boolean getCanRestock() {
        return this.canRestock;
    }

    public boolean getIsFinal() {
        return this.isFinalized;
    }
}

