/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_client;

import com.ma.ManaAndArtifice;
import com.ma.network.messages.BaseMessage;
import com.ma.tools.math.Vector3;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class SpawnParticleMessage
extends BaseMessage {
    Vector3 position;
    Vector3 speed;
    ResourceLocation type;

    public SpawnParticleMessage(double x, double y, double z, double vX, double vY, double vZ, ResourceLocation type) {
        this.position = new Vector3(x, y, z);
        this.speed = new Vector3(vX, vY, vZ);
        this.type = type;
        this.messageIsValid = true;
    }

    public SpawnParticleMessage() {
        this.messageIsValid = false;
    }

    public Vector3 getPosition() {
        return this.position;
    }

    public Vector3 getSpeed() {
        return this.speed;
    }

    public ResourceLocation getType() {
        return this.type;
    }

    public static SpawnParticleMessage decode(PacketBuffer buf) {
        SpawnParticleMessage msg = new SpawnParticleMessage();
        try {
            msg.type = buf.func_192575_l();
            msg.position = new Vector3(buf.readDouble(), buf.readDouble(), buf.readDouble());
            msg.speed = new Vector3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading SpawnParticleMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(SpawnParticleMessage message, PacketBuffer buf) {
        buf.func_192572_a(message.getType());
        buf.writeDouble((double)message.getPosition().x);
        buf.writeDouble((double)message.getPosition().y);
        buf.writeDouble((double)message.getPosition().z);
        buf.writeDouble((double)message.getSpeed().x);
        buf.writeDouble((double)message.getSpeed().y);
        buf.writeDouble((double)message.getSpeed().z);
    }
}

