/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_client;

import com.ma.ManaAndArtifice;
import com.ma.blocks.tileentities.ManaweavingAltarTile;
import com.ma.network.messages.BaseMessage;
import com.ma.tools.math.Vector3;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class SpawnParticleEffectMessage
extends BaseMessage {
    Vector3 position;
    ParticleTypes particleType;

    public SpawnParticleEffectMessage(double x, double y, double z, ParticleTypes type) {
        this.position = new Vector3(x, y, z);
        this.particleType = type;
        this.messageIsValid = true;
    }

    public SpawnParticleEffectMessage() {
        this.messageIsValid = false;
    }

    public Vector3 getPosition() {
        return this.position;
    }

    public ParticleTypes getType() {
        return this.particleType;
    }

    public static SpawnParticleEffectMessage decode(PacketBuffer buf) {
        SpawnParticleEffectMessage msg = new SpawnParticleEffectMessage();
        try {
            msg.particleType = ParticleTypes.valueOf(ParticleTypes.class, buf.func_150789_c(Short.MAX_VALUE));
            msg.position = new Vector3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading SpawnParticleEffectMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(SpawnParticleEffectMessage message, PacketBuffer buf) {
        buf.func_180714_a(message.getType().name());
        buf.writeDouble((double)message.getPosition().x);
        buf.writeDouble((double)message.getPosition().y);
        buf.writeDouble((double)message.getPosition().z);
    }

    public void handle(World world) {
        switch (this.particleType) {
            case MANAWEAVE_CRAFT_COMPLETE: {
                ManaweavingAltarTile.spawnCraftCompleteParticles(world, new Vector3f(this.position.x, this.position.y, this.position.z));
            }
        }
    }

    public static enum ParticleTypes {
        MANAWEAVE_CRAFT_COMPLETE;

    }
}

