/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_client;

import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.network.messages.BaseMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ProgressionSyncMessageToClient
extends BaseMessage {
    private int _tier;
    private Faction _faction;
    private int _factionStanding;
    private List<ResourceLocation> completedProgressionSteps;

    private ProgressionSyncMessageToClient() {
        this.completedProgressionSteps = new ArrayList<ResourceLocation>();
        this.messageIsValid = false;
    }

    public ProgressionSyncMessageToClient(int tier, Faction faction, int factionStanding, List<ResourceLocation> progressionCompletion) {
        this.completedProgressionSteps = progressionCompletion;
        this._tier = tier;
        this._faction = faction;
        this._factionStanding = factionStanding;
        this.messageIsValid = true;
    }

    public int getTier() {
        return this._tier;
    }

    public Faction getFaction() {
        return this._faction;
    }

    public int getFactionStanding() {
        return this._factionStanding;
    }

    public List<ResourceLocation> getCompletedProgressionSteps() {
        return this.completedProgressionSteps;
    }

    public static ProgressionSyncMessageToClient decode(PacketBuffer buf) {
        ProgressionSyncMessageToClient msg = new ProgressionSyncMessageToClient();
        try {
            msg._tier = buf.readInt();
            msg._factionStanding = buf.readInt();
            msg._faction = Faction.valueOf(buf.func_218666_n());
            int count = buf.readInt();
            for (int i = 0; i < count; ++i) {
                msg.completedProgressionSteps.add(buf.func_192575_l());
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading MagicSyncMessageToClient: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(ProgressionSyncMessageToClient msg, PacketBuffer buf) {
        buf.writeInt(msg.getTier());
        buf.writeInt(msg.getFactionStanding());
        buf.func_180714_a(msg.getFaction().name());
        buf.writeInt(msg.getCompletedProgressionSteps().size());
        for (ResourceLocation rLoc : msg.getCompletedProgressionSteps()) {
            buf.func_192572_a(rLoc);
        }
    }

    public static ProgressionSyncMessageToClient fromCapability(IPlayerProgression capability) {
        return new ProgressionSyncMessageToClient(capability.getTier(), capability.getAlliedFaction(), capability.getFactionStanding(), capability.getCompletedProgressionSteps());
    }
}

