/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_client;

import com.ma.ManaAndArtifice;
import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.resource.SyncStatus;
import com.ma.network.messages.BaseMessage;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;

public class MagicSyncMessageToClient
extends BaseMessage {
    private int _level;
    private int _xp;
    private float[] _affinities;
    private NonNullList<ItemStack> _grimoireInventory;
    private NonNullList<ItemStack> _roteInventory;
    private CompoundNBT _cantripData;
    private CompoundNBT castingResourceData;
    private boolean _syncGrimoire;
    private boolean _syncRote;
    private boolean _syncCastingResource;
    private boolean _syncCantrips;

    private MagicSyncMessageToClient() {
        this.messageIsValid = false;
        this._grimoireInventory = NonNullList.func_191196_a();
        this._roteInventory = NonNullList.func_191196_a();
    }

    public MagicSyncMessageToClient(int level, int xp, float[] affinities) {
        this();
        this._level = level;
        this._xp = xp;
        this._affinities = affinities;
        this.messageIsValid = true;
    }

    @Nullable
    public CompoundNBT getCastingResourceData() {
        return this.castingResourceData;
    }

    public int getLevel() {
        return this._level;
    }

    public int getXP() {
        return this._xp;
    }

    public float[] getAffinities() {
        return this._affinities;
    }

    public boolean syncGrimoire() {
        return this._syncGrimoire;
    }

    public boolean syncRote() {
        return this._syncRote;
    }

    public boolean syncCastingResource() {
        return this._syncCastingResource;
    }

    public boolean syncCantrips() {
        return this._syncCantrips;
    }

    @Nullable
    public NonNullList<ItemStack> getGrimoireInventory() {
        return this._grimoireInventory;
    }

    @Nullable
    public NonNullList<ItemStack> getRoteInventory() {
        return this._roteInventory;
    }

    @Nullable
    public CompoundNBT getCantripData() {
        return this._cantripData;
    }

    public static MagicSyncMessageToClient decode(PacketBuffer buf) {
        MagicSyncMessageToClient msg = new MagicSyncMessageToClient();
        try {
            int i;
            int count;
            msg._level = buf.readInt();
            msg._xp = buf.readInt();
            int affC = buf.readInt();
            msg._affinities = new float[affC];
            for (int i2 = 0; i2 < affC; ++i2) {
                msg._affinities[i2] = buf.readFloat();
            }
            msg._syncCastingResource = buf.readBoolean();
            if (msg._syncCastingResource) {
                msg.castingResourceData = buf.func_150793_b();
            }
            msg._syncGrimoire = buf.readBoolean();
            if (msg._syncGrimoire) {
                count = buf.readInt();
                for (i = 0; i < count; ++i) {
                    msg._grimoireInventory.add((Object)buf.func_150791_c());
                }
            }
            msg._syncRote = buf.readBoolean();
            if (msg._syncRote) {
                count = buf.readInt();
                for (i = 0; i < count; ++i) {
                    msg._roteInventory.add((Object)buf.func_150791_c());
                }
            }
            msg._syncCantrips = buf.readBoolean();
            if (msg._syncCantrips) {
                msg._cantripData = buf.func_150793_b();
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading MagicSyncMessageToClient: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(MagicSyncMessageToClient msg, PacketBuffer buf) {
        int i;
        buf.writeInt(msg._level);
        buf.writeInt(msg._xp);
        buf.writeInt(msg._affinities.length);
        for (i = 0; i < msg._affinities.length; ++i) {
            buf.writeFloat(msg._affinities[i]);
        }
        buf.writeBoolean(msg.syncCastingResource());
        if (msg.syncCastingResource()) {
            buf.func_150786_a(msg.castingResourceData);
        }
        buf.writeBoolean(msg.syncGrimoire());
        if (msg.syncGrimoire()) {
            buf.writeInt(msg._grimoireInventory.size());
            for (i = 0; i < msg._grimoireInventory.size(); ++i) {
                buf.func_150788_a((ItemStack)msg._grimoireInventory.get(i));
            }
        }
        buf.writeBoolean(msg.syncRote());
        if (msg.syncRote()) {
            buf.writeInt(msg._roteInventory.size());
            for (i = 0; i < msg._roteInventory.size(); ++i) {
                buf.func_150788_a((ItemStack)msg._roteInventory.get(i));
            }
        }
        buf.writeBoolean(msg.syncCantrips());
        if (msg.syncCantrips()) {
            buf.func_150786_a(msg._cantripData);
        }
    }

    public static MagicSyncMessageToClient fromCapability(IPlayerMagic capability) {
        int i;
        float[] f = new float[Affinity.values().length];
        if (capability == null) {
            return new MagicSyncMessageToClient(0, 0, f);
        }
        int count = 0;
        for (Affinity aff : Affinity.values()) {
            f[count++] = capability.getAffinityDepth(aff);
        }
        MagicSyncMessageToClient msg = new MagicSyncMessageToClient(capability.getMagicLevel(), capability.getMagicXP(), f);
        if (capability.getCastingResource().getSyncStatus() != SyncStatus.NOT_NEEDED) {
            msg._syncCastingResource = true;
            msg.castingResourceData = new CompoundNBT();
            capability.getCastingResource().writeNBT(msg.castingResourceData);
        }
        if (capability.shouldSyncGrimoire()) {
            msg._syncGrimoire = true;
            for (i = 0; i < capability.getGrimoireInventory().func_70302_i_(); ++i) {
                msg._grimoireInventory.add((Object)capability.getGrimoireInventory().func_70301_a(i));
            }
        }
        if (capability.shouldSyncRote()) {
            msg._syncRote = true;
            for (i = 0; i < capability.getRoteInventory().func_70302_i_(); ++i) {
                msg._roteInventory.add((Object)capability.getRoteInventory().func_70301_a(i));
            }
        }
        if (capability.getCantripData().needsSync()) {
            msg._syncCantrips = true;
            msg._cantripData = capability.getCantripData().writeToNBT(false);
        }
        return msg;
    }
}

